/*
 * Decompiled with CFR 0.152.
 */
package com.mistamek.drawablepreview.factories;

import com.mistamek.drawablepreview.settings.SettingsUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/mistamek/drawablepreview/factories/SvgImageFactory;", "", "()V", "createSvgImage", "Ljava/awt/image/BufferedImage;", "path", "", "drawable-preview"})
public final class SvgImageFactory {
    public static final SvgImageFactory INSTANCE;

    @Nullable
    public final BufferedImage createSvgImage(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        PNGTranscoder transcoder = new PNGTranscoder();
        transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(SettingsUtils.INSTANCE.getPreviewSize()));
        transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(SettingsUtils.INSTANCE.getPreviewSize()));
        try {
            FileInputStream inputStream = new FileInputStream(new File(path));
            TranscoderInput input = new TranscoderInput((InputStream)inputStream);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            TranscoderOutput output = new TranscoderOutput((OutputStream)outputStream);
            transcoder.transcode(input, output);
            outputStream.flush();
            outputStream.close();
            byte[] imgData = outputStream.toByteArray();
            return ImageIO.read(new ByteArrayInputStream(imgData));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private SvgImageFactory() {
    }

    static {
        SvgImageFactory svgImageFactory;
        INSTANCE = svgImageFactory = new SvgImageFactory();
    }
}

