-- use the configuration in addto_pascal.properties

--lua-functions
-- openPasFromDpr() opens all files from current dpr-file
function openPasFromDpr()
  local path = props['FileDir']  --without trailing /\
  local file = props['FilePath']  --the projectfile used for changing back to this buffer
  local text = editor:textrange(0, editor.Length)
  for uses in string.gfind(text, "uses.-;") do
    uses = string.gsub(uses,"//.-\n","")
    uses = string.gsub(uses,"{.-}","")
    uses = string.gsub(uses,"%(%*.-%*%)","")
    for c in string.gfind(uses, "\'([^\']*)\'") do
      if not (string.gfind(c,":")) then
        c=path .. '\\' .. c
      end
        scite.Open(c)
    end
  end
  scite.Open(file)
end 

-- getDprFiles() builds the list of files from current dpr-file
function getDprFiles()
  local path = props['FileDir']  --without trailing /\
  local file = props['FilePath']  --the projectfile used for changing back to this buffer
  local text = editor:textrange(0, editor.Length)
  local files = {}
  local i = 1
  for uses in string.gfind(text, "uses.-;") do
    uses = string.gsub(uses,"//.-\n","")
    uses = string.gsub(uses,"{.-}","")
    uses = string.gsub(uses,"%(%*.-%*%)","")
    for c in string.gfind(uses, "\'([^\']*)\'") do
      if not (string.find(c,":")) then
        c=path .. '\\' .. c
      end
      files[i] = c
      i = i + 1
    end
  end
  return files
end 

-- SelectDPRFile() shows list with all files frpm curent dpr-file
function SelectDPRFile()
  local files = getDprFiles()
  if table.getn(files) == 0 then return 0 end
  local s = ''
  local sep = ';'
  local n = table.getn(files)
  for i = 1,n-1 do
    s = s..files[i]..sep
  end
  s = s..files[n]
  editor.AutoCSeparator = string.byte(sep)
  editor:UserListShow(11,s)
  editor.AutoCSeparator = string.byte(' ')
  return 0
end

--jumps to line and expand all folds needed to show current position
function ShowCompactedLine(line_num)
  local function GetExpandedLine(l)
    for i = l, 0, -1 do
            if not editor.FoldExpanded[i] then return i end
    end
  end
  while not editor.LineVisible[line_num] do
    local x = GetExpandedLine(line_num)
    editor:ToggleFold(x)
    line_num = x - 1
  end
end

-- jumps to declaration of function in implementation section at current cursor position
function GotoDefinition()
  line = editor:LineFromPosition(editor.CurrentPos)
  text=Chomp(editor:GetLine(line))
  if (string.match(text:lower(),"^function")~=nil) or (string.match(text:lower(),"^procedure")~=nil) then
    local def=string.gsub(text,"(.*)[(].*","%1")
    if (string.match(def,".*[.].*")~=nil) then
      local cl=string.gsub(def,".* (.*)[.].*","%1")
      local fname=string.gsub(def,"(.* ).*[.](.*)","%1%2")
      s=editor:findtext("^.*"..cl..".*class.*[^;]$",SCFIND_REGEXP)
      if s ~= nil then
        startline = editor:LineFromPosition(s) + 1
        fs=editor:findtext(fname,SCFIND_REGEXP,s)
        if fs~=nil then
          l=editor:LineFromPosition(fs)
          ShowCompactedLine(l)
          editor:GotoLine(l)
        end
      end 
    end
  end
end


