-- Automatic block completion
-- Copyrighted by Mario Ray M.
-- license: same as Lua

-- Block completion for C languages family, only '{'
local function CBlock(Line)
  -- determine whether a block is already completed
  local function BlockCompleted()
    local s = stack()
    -- start from first character
    local i = 0
    -- look for possible unclosed open block until caret position
    while i < editor.CurrentPos do
      local c = EditorCharAt(i)
      if c == '{' then
        s:push(i)
      -- ignore superfluous close block, it's OK if before our
      -- most recent open block
      elseif c == '}' and s.top > 0 then
        s:pop()
      end
      i = i + 1
    end
    -- look for possible unclosed open block until end of file
    while i < editor.Length do
      local c = EditorCharAt(i)
      if c == '{' then
        s:push(i)
      elseif c == '}' then
        s:pop()
        -- once the stack got empty, that means our most recent open
        -- block has been closed, therefore don't insert the close block
        if s.top == 0 then return true end
      end
      i = i + 1
    end
    -- there are still open blocks, insert the close block
    return false
  end

  local PrevLine = strip_eol(editor:GetLine(editor:LineFromPosition(editor.CurrentPos)-1))
  local _,_,Ch = LastChar(PrevLine)
  if Ch == '{' then
    local _,_,Indent = IndentSize(PrevLine)
    if not BlockCompleted() then
      local CursorPos = editor.CurrentPos
      editor:AddText('\n' .. Indent .. '}')
      editor:GotoPos(CursorPos)
    end
  end
end

-- Block completion for Pascal, everything in BlockMatches
-- Currently, only supports 'class' and 'interface' without inheritance
-- need to find the correct lua pattern (see LastWord() in strings.lua)
local function PascalBlock(Line)
  local BlockMatches = {
    ['begin']     = 'end;',
    ['record']    = 'end;',
    ['class']     = 'end;',
    ['interface'] = 'end;',
    ['repeat']    = 'until ;'
  }
  local PrevLine = strip_eol(editor:GetLine(editor:LineFromPosition(editor.CurrentPos)-1))
  local _,_,Word = LastWord(PrevLine)
  if Word and BlockMatches[Word] then
    local _,_,Indent = IndentSize(PrevLine)
    editor:AddText('  ')
    local CursorPos = editor.CurrentPos
    editor:AddText('\n' .. Indent .. BlockMatches[Word])
    editor:GotoPos(CursorPos)
  end
end

-- lexer - block function relation
local BlockFunctions = {
  [SCLEX_CPP]    = CBlock,
  [SCLEX_PASCAL] = PascalBlock
}

function AutoBlock(Line)
  local Func = BlockFunctions[editor.Lexer]
  if Func then Func(Line) end
end

scite_OnEditorLine(AutoBlock)
