//build@ gcc -shared -o shellexec.dll -I..\..\lua\include shellexec.c scite.la 
#include <windows.h>
#include <lua.h>
#include <lauxlib.h>
#include <lualib.h>

static int exec (lua_State *L)
{
    const char *file = lua_tostring(L,1);
    const char *parms = lua_tostring(L,2);
    int noshow = lua_toboolean(L,3);
    const char *verb = lua_tostring(L,4);
    HINSTANCE hInst = ShellExecute(
        NULL,
        verb,
        file,
        parms,
        NULL,
        noshow ? SW_HIDE : SW_SHOWNORMAL);
    lua_pushboolean(L,(int)hInst > 32);
    return 1;
}

static const struct luaL_reg shellexec[] = {
	{"exec",exec},
    {NULL,NULL}
};

__declspec(dllexport)
int luaopen_shellexec(lua_State *L)
{
	luaL_openlib (L, "shellexec", shellexec, 0);
	return 1;	
}
