/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.common.util;

import java.util.List;

public class HangulUtil {
    public static final char[] CHO_SUNG = new char[]{'\u3131', '\u3132', '\u3134', '\u3137', '\u3138', '\u3139', '\u3141', '\u3142', '\u3143', '\u3145', '\u3146', '\u3147', '\u3148', '\u3149', '\u314a', '\u314b', '\u314c', '\u314d', '\u314e'};
    public static final char[] JUNG_SUNG = new char[]{'\u314f', '\u3150', '\u3151', '\u3152', '\u3153', '\u3154', '\u3155', '\u3156', '\u3157', '\u3158', '\u3159', '\u315a', '\u315b', '\u315c', '\u315d', '\u315e', '\u315f', '\u3160', '\u3161', '\u3162', '\u3163'};
    public static final char[] JONG_SUNG = new char[]{' ', '\u3131', '\u3132', '\u3133', '\u3134', '\u3135', '\u3136', '\u3137', '\u3139', '\u313a', '\u313b', '\u313c', '\u313d', '\u313e', '\u313f', '\u3140', '\u3141', '\u3142', '\u3144', '\u3145', '\u3146', '\u3147', '\u3148', '\u314a', '\u314b', '\u314c', '\u314d', '\u314e'};
    public static final int START_KOREA_UNICODE_DECIMAL = 44032;

    public static int getOneHangulJamoSize(int startIdx, List<String> jamoList) {
        int remainJamoSize = jamoList.size() - startIdx;
        if (remainJamoSize == 1) {
            return -1;
        }
        if (remainJamoSize == 2 || remainJamoSize == 3) {
            return remainJamoSize;
        }
        String strJungSung = new String(JUNG_SUNG);
        String strChar = jamoList.get(startIdx + 3);
        if (strJungSung.contains(strChar)) {
            return 2;
        }
        return 3;
    }

    public static int getChoSungIndex(int startIdx, List<String> jamoList) {
        String strChoSung = new String(CHO_SUNG);
        String strChoSungChar = jamoList.get(startIdx);
        return strChoSung.indexOf(strChoSungChar);
    }

    public static int getJungSungIndex(int startIdx, List<String> jamoList) {
        String strJungSung = new String(JUNG_SUNG);
        String strJungSungChar = jamoList.get(startIdx + 1);
        return strJungSung.indexOf(strJungSungChar);
    }

    public static int getJongSungIndex(int startIdx, List<String> jamoList) {
        String strJongSung = new String(JONG_SUNG);
        String strJongSungChar = jamoList.get(startIdx + 2);
        return strJongSung.indexOf(strJongSungChar);
    }
}

