/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis.eng2kor;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.elasticsearch.index.common.converter.EngToKorConverter;

public final class JavacafeEng2KorConvertFilter3
extends TokenFilter {
    private EngToKorConverter converter = new EngToKorConverter();
    private CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private PositionIncrementAttribute positionIncrementAttribute = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private Queue<char[]> simpleQueue = new LinkedList<char[]>();

    public JavacafeEng2KorConvertFilter3(TokenStream stream) {
        super(stream);
    }

    public boolean incrementToken() throws IOException {
        if (!this.simpleQueue.isEmpty()) {
            char[] buffer = this.simpleQueue.poll();
            this.termAtt.setEmpty();
            this.termAtt.copyBuffer(buffer, 0, buffer.length);
            this.positionIncrementAttribute.setPositionIncrement(0);
            return true;
        }
        if (this.input.incrementToken()) {
            String result = this.converter.convert(this.termAtt.toString());
            this.simpleQueue.add(result.toCharArray());
            return true;
        }
        return false;
    }
}

