/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.common.converter;

import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.common.type.CodeType;
import org.elasticsearch.index.common.util.KeyboardUtil;

public class KorToEngConverter {
    public String convert(String token) {
        StringBuilder sb = new StringBuilder();
        String word = token.trim();
        for (int index = 0; index < word.length(); ++index) {
            char init;
            int initUnicode;
            if ("`1234567890-=[]\\;',./~!@#$%^&*()_+{}|:\"<>?' ' ".indexOf(word.substring(index, index + 1)) > -1) {
                sb.append(word.substring(index, index + 1));
                ++index;
            }
            if ((initUnicode = (init = word.charAt(index)) - 44032) > 0) {
                int jong;
                String strJong;
                int jung;
                String strJung;
                int cho = initUnicode / 21 / 28;
                String strCho = this.getSameEngChar(CodeType.CHOSUNG, cho);
                if (StringUtils.isNotEmpty((CharSequence)strCho)) {
                    sb.append(strCho);
                }
                if (StringUtils.isNotEmpty((CharSequence)(strJung = this.getSameEngChar(CodeType.JUNGSUNG, jung = initUnicode / 28 % 21)))) {
                    sb.append(strJung);
                }
                if (!StringUtils.isNotEmpty((CharSequence)(strJong = this.getSameEngChar(CodeType.JONGSUNG, jong = initUnicode % 28)))) continue;
                sb.append(strJong);
                continue;
            }
            String subStr = String.valueOf(init);
            sb.append(this.getSameEngCharForJamo(subStr, 0));
        }
        return sb.toString();
    }

    private String getSameEngChar(CodeType type, int pos) {
        switch (type) {
            case CHOSUNG: {
                return KeyboardUtil.KEYBOARD_CHO_SUNG[pos];
            }
            case JUNGSUNG: {
                return KeyboardUtil.KEYBOARD_JUNG_SUNG[pos];
            }
            case JONGSUNG: {
                if (pos - 1 > -1) {
                    return KeyboardUtil.KEYBOARD_JONG_SUNG[pos - 1];
                }
                return "";
            }
        }
        return "";
    }

    private String getSameEngCharForJamo(String key, int pos) {
        for (int i = 0; i < KeyboardUtil.KEYBOARD_KEY_KOR.length; ++i) {
            if (!KeyboardUtil.KEYBOARD_KEY_KOR[i].equals(key)) continue;
            return KeyboardUtil.KEYBOARD_KEY_ENG[i];
        }
        return "";
    }
}

