/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.common.parser;

import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.common.util.JamoUtil;

public abstract class AbstractKoreanParser {
    public String parse(String token) {
        char[] arrCh;
        if (StringUtils.isBlank((CharSequence)token)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (char ch : arrCh = token.toCharArray()) {
            char unicodeIndex = (char)(ch - 44032);
            if (unicodeIndex >= '\u0000' && unicodeIndex <= '\u2bb0') {
                int idxChoSung = unicodeIndex / 588;
                char chosung = JamoUtil.UNICODE_CHO_SUNG[idxChoSung];
                int idxJungSung = unicodeIndex % 588 / 28;
                char jungsung = JamoUtil.UNICODE_JUNG_SUNG[idxJungSung];
                int idxJongSung = unicodeIndex % 588 % 28;
                char jongsung = JamoUtil.UNICODE_JONG_SUNG[idxJongSung];
                this.processForKoreanChar(result, chosung, jungsung, jongsung);
                continue;
            }
            this.processForOther(result, ch);
        }
        return result.toString();
    }

    protected abstract void processForKoreanChar(StringBuilder var1, char var2, char var3, char var4);

    protected abstract void processForOther(StringBuilder var1, char var2);
}

