/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.common.util;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.index.common.type.CodeType;

public class KeyboardUtil {
    public static final String IGNORE_CHAR = "`1234567890-=[]\\;',./~!@#$%^&*()_+{}|:\"<>?' ' ";
    public static final String[] KEYBOARD_CHO_SUNG = new String[]{"r", "R", "s", "e", "E", "f", "a", "q", "Q", "t", "T", "d", "w", "W", "c", "z", "x", "v", "g"};
    public static final String[] KEYBOARD_JUNG_SUNG = new String[]{"k", "o", "i", "O", "j", "p", "u", "P", "h", "hk", "ho", "hl", "y", "n", "nj", "np", "nl", "b", "m", "ml", "l"};
    public static final String[] KEYBOARD_JONG_SUNG = new String[]{"r", "R", "rt", "s", "sw", "sg", "e", "f", "fr", "fa", "fq", "ft", "fx", "fv", "fg", "a", "q", "qt", "t", "T", "d", "w", "c", "z", "x", "v", "g"};
    public static final String[] KEYBOARD_KEY_ENG = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "Q", "W", "E", "R", "T", "O", "P"};
    public static final String[] KEYBOARD_KEY_KOR = new String[]{"\u3141", "\u3160", "\u314a", "\u3147", "\u3137", "\u3139", "\u314e", "\u3157", "\u3151", "\u3153", "\u314f", "\u3163", "\u3161", "\u315c", "\u3150", "\u3154", "\u3142", "\u3131", "\u3134", "\u3145", "\u3155", "\u314d", "\u3148", "\u314c", "\u315b", "\u314b", "\u3143", "\u3149", "\u3138", "\u3132", "\u3146", "\u3152", "\u3156"};

    public static Map<String, Integer> getInfoForChoSung(int index, String word) {
        int code = KeyboardUtil.makeUnicodeIndex(CodeType.CHOSUNG, word.substring(index, index + 1));
        int idx = index + 1;
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("code", code);
        m.put("idx", idx);
        return m;
    }

    public static Map<String, Integer> getInfoForJungSung(int index, String word) {
        int code = KeyboardUtil.getDoubleMedial(index, word);
        int idx = index + 2;
        if (-1 == code) {
            code = KeyboardUtil.getSingleMedial(index, word);
            idx = index + 1;
        }
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("code", code);
        m.put("idx", idx);
        return m;
    }

    public static Map<String, Integer> getInfoForJongSung(int index, String word) {
        int code;
        int idx = index;
        int temp = KeyboardUtil.getDoubleFinal(idx, word);
        if (-1 == temp) {
            temp = KeyboardUtil.getSingleMedial(idx + 1, word);
            if (temp != -1) {
                code = 0;
                --idx;
            } else {
                code = KeyboardUtil.getSingleFinal(idx, word);
                if (code == -1) {
                    code = 0;
                    --idx;
                }
            }
        } else {
            code = temp;
            temp = KeyboardUtil.getSingleMedial(idx + 2, word);
            if (temp != -1) {
                code = KeyboardUtil.getSingleFinal(idx, word);
            } else {
                ++idx;
            }
        }
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("code", code);
        m.put("idx", idx);
        return m;
    }

    private static int getSingleMedial(int index, String word) {
        if (index + 1 <= word.length()) {
            return KeyboardUtil.makeUnicodeIndex(CodeType.JUNGSUNG, word.substring(index, index + 1));
        }
        return -1;
    }

    private static int getDoubleMedial(int index, String word) {
        if (index + 2 > word.length()) {
            return -1;
        }
        return KeyboardUtil.makeUnicodeIndex(CodeType.JUNGSUNG, word.substring(index, index + 2));
    }

    private static int getSingleFinal(int index, String word) {
        if (index + 1 <= word.length()) {
            return KeyboardUtil.makeUnicodeIndex(CodeType.JONGSUNG, word.substring(index, index + 1));
        }
        return -1;
    }

    private static int getDoubleFinal(int index, String word) {
        if (index + 2 > word.length()) {
            return -1;
        }
        return KeyboardUtil.makeUnicodeIndex(CodeType.JONGSUNG, word.substring(index, index + 2));
    }

    private static int makeUnicodeIndex(CodeType type, String subStr) {
        switch (type) {
            case CHOSUNG: {
                for (int i = 0; i < KEYBOARD_CHO_SUNG.length; ++i) {
                    if (!KEYBOARD_CHO_SUNG[i].equals(subStr)) continue;
                    return i * 28 * 21;
                }
                break;
            }
            case JUNGSUNG: {
                for (int i = 0; i < KEYBOARD_JUNG_SUNG.length; ++i) {
                    if (!KEYBOARD_JUNG_SUNG[i].equals(subStr)) continue;
                    return i * 28;
                }
                break;
            }
            case JONGSUNG: {
                for (int i = 0; i < KEYBOARD_JONG_SUNG.length; ++i) {
                    if (!KEYBOARD_JONG_SUNG[i].equals(subStr)) continue;
                    return i + 1;
                }
                break;
            }
        }
        return -1;
    }
}

