const road1Img = "img/road1.png";
const road2Img = "img/road2.png";
const road3Img = "img/road3.png";
const road4Img = "img/road4.png";
const road5Img = "img/road5.png";
const road6Img = "img/road6.png";

var count = 0;

const imgDict = [
  { url: road1Img, tag: "road1" },
  { url: road2Img, tag: "road2" },
  { url: road3Img, tag: "road3" },
  { url: road4Img, tag: "road4" },
  { url: road5Img, tag: "road5" },
  { url: road6Img, tag: "road6" }
];

function generateFormular() {
  let m = document.createElement("INPUT");
  m.setAttribute("type", "number");
  m.setAttribute("id", "idM");

  let n = document.createElement("INPUT");
  n.setAttribute("type", "number");
  n.setAttribute("id", "idN");

  let btn = document.createElement("BUTTON");
  btn.setAttribute("type", "BUTTON");
  btn.innerHTML = "generate";
  btn.addEventListener("click", generateGrid);

  let div1 = document.createElement("DIV");

  let gridDiv = document.createElement("DIV");
  gridDiv.setAttribute("id", "gridDiv");

  div1.appendChild(m);
  div1.appendChild(n);
  div1.appendChild(btn);

  document.body.appendChild(div1);
  document.body.appendChild(gridDiv);
}

function generateGrid() {
  const M = parseInt(document.getElementById("idM").value);
  const N = parseInt(document.getElementById("idN").value);

  if (M < 1 || N < 1) {
    alert("M and N must be at least 1");
  }

  let gridDiv = document.getElementById("gridDiv");
  gridDiv.innerHTML = "";

  let roads = document.getElementById("roadsDivId");
  if (roads) {
    roads.remove();
  }
  // console.log(roads);
  // if (roads.length > 0) {
  //   for (let i = 0; roads.length; i++) {
  //     roads[i].remove();
  //   }
  // }

  for (let i = 0; i < M; i++) {
    let row = document.createElement("div");
    row.className = "row";
    for (let j = 0; j < N; j++) {
      let cell = document.createElement("div");
      cell.className = "grid-square";
      //cell.innerText = i * N + j;
      cell.addEventListener("dragover", onDragOver);
      cell.addEventListener("drop", onDrop);
      row.appendChild(cell);
    }
    gridDiv.appendChild(row);
  }

  readAllImages();
}

function createImg(url, tag) {
  let wrapper = document.createElement("DIV");
  wrapper.className = "roads-div";

  let image = document.createElement("IMG");
  image.className = "roads";
  image.setAttribute("draggable", "true");
  image.setAttribute("src", url);
  image.setAttribute("data-tag", tag);
  image.setAttribute("id", count);

  image.addEventListener("dragstart", onDragStart);

  count++;

  wrapper.appendChild(image);
  return wrapper;
}

function readAllImages() {
  let roadsDiv = document.createElement("DIV");
  roadsDiv.setAttribute("id", "roadsDivId");

  imgDict.map(key => {
    const wrp = createImg(key.url, key.tag);
    roadsDiv.appendChild(wrp);
  });

  document.body.appendChild(roadsDiv);
}

function onDragStart(event) {
  const id = event.target.getAttribute("id");
  event.dataTransfer.setData("text/plain", id);
}

function onDragOver(event) {
  event.preventDefault();
}

function onDrop(event) {
  const id = event.dataTransfer.getData("text");
  const draggableElement = document.getElementById(id);
  const dropzone = event.currentTarget;

  if (dropzone.childElementCount === 0) {
    let tag = draggableElement.getAttribute("data-tag");
    const index = parseInt(tag.slice(-1)) - 1;
    const imgRow = imgDict[index];
    console.log(imgRow, index);
    const wrp = createImg(imgRow.url, imgRow.tag);
    draggableElement.parentElement.replaceWith(wrp);
    dropzone.appendChild(draggableElement);
    draggableElement.setAttribute("draggable", "false");
  }
  event.dataTransfer.clearData();
}
