/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.felix.webconsole.VariableResolver;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.filter.ResourceFilteringWriter;

public class FilteringResponseWrapper
extends HttpServletResponseWrapper {
    private final ResourceBundle locale;
    private final ServletRequest request;
    private PrintWriter writer;

    public FilteringResponseWrapper(HttpServletResponse response, ResourceBundle locale, ServletRequest request) {
        super(response);
        this.locale = locale;
        this.request = request;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            PrintWriter base = super.getWriter();
            if (this.doWrap()) {
                VariableResolver resolver = WebConsoleUtil.getVariableResolver(this.request);
                ResourceFilteringWriter filter = new ResourceFilteringWriter(base, this.locale, resolver);
                this.writer = new PrintWriter(filter);
            } else {
                this.writer = base;
            }
        }
        return this.writer;
    }

    private final boolean doWrap() {
        boolean doWrap = this.getContentType() != null && this.getContentType().indexOf("text/html") >= 0;
        return doWrap;
    }
}

