/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.system;

import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.startlevel.StartLevel;

public class VMStatPlugin
extends SimpleWebConsolePlugin
implements OsgiManagerPlugin {
    private static final long serialVersionUID = 2293375003997163600L;
    private static final String LABEL = "vmstat";
    private static final String TITLE = "%vmstat.pluginTitle";
    private static final String[] CSS = null;
    private static final String ATTR_TERMINATED = "terminated";
    private static final String PARAM_SHUTDOWN_TIMER = "shutdown_timer";
    private static final String PARAM_SHUTDOWN_TYPE = "shutdown_type";
    private static final String PARAM_SHUTDOWN_TYPE_RESTART = "Restart";
    private static final long startDate = System.currentTimeMillis();
    private static String START_LEVEL_NAME = StartLevel.class.getName();
    private final String TPL_VM_MAIN = this.readTemplateFile("/templates/vmstat.html");
    private final String TPL_VM_STOP = this.readTemplateFile("/templates/vmstat_stop.html");
    private final String TPL_VM_RESTART = this.readTemplateFile("/templates/vmstat_restart.html");

    public VMStatPlugin() {
        super(LABEL, TITLE, "Web Console", CSS);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("action");
        if ("setStartLevel".equals(action)) {
            StartLevel sl = this.getStartLevel();
            if (sl != null) {
                int systemSL;
                int bundleSL = WebConsoleUtil.getParameterInt(request, "bundleStartLevel", -1);
                if (bundleSL > 0 && bundleSL != sl.getInitialBundleStartLevel()) {
                    sl.setInitialBundleStartLevel(bundleSL);
                }
                if ((systemSL = WebConsoleUtil.getParameterInt(request, "systemStartLevel", -1)) > 0 && systemSL != sl.getStartLevel()) {
                    sl.setStartLevel(systemSL);
                }
            }
        } else if ("gc".equals(action)) {
            System.gc();
            System.gc();
        } else if (request.getParameter(PARAM_SHUTDOWN_TIMER) == null) {
            final boolean restart = PARAM_SHUTDOWN_TYPE_RESTART.equals(request.getParameter(PARAM_SHUTDOWN_TYPE));
            final Bundle systemBundle = this.getBundleContext().getBundle(0L);
            Thread t = new Thread("Stopper"){

                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    VMStatPlugin.this.log("Shutting down server now!");
                    try {
                        if (restart) {
                            systemBundle.update();
                        } else {
                            systemBundle.stop();
                        }
                    }
                    catch (BundleException be) {
                        VMStatPlugin.this.log("Problem stopping or restarting the Framework", be);
                    }
                }
            };
            t.start();
            request.setAttribute(ATTR_TERMINATED, (Object)ATTR_TERMINATED);
            request.setAttribute(PARAM_SHUTDOWN_TYPE, (Object)new Boolean(restart));
        }
        this.doGet(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getAttribute(ATTR_TERMINATED) != null) {
            Object restart = request.getAttribute(PARAM_SHUTDOWN_TYPE);
            String body = restart instanceof Boolean && (Boolean)restart != false ? this.TPL_VM_RESTART : this.TPL_VM_STOP;
            response.getWriter().print(body);
            return;
        }
        String body = this.TPL_VM_MAIN;
        long freeMem = Runtime.getRuntime().freeMemory() / 1024L;
        long totalMem = Runtime.getRuntime().totalMemory() / 1024L;
        long usedMem = totalMem - freeMem;
        boolean shutdownTimer = request.getParameter(PARAM_SHUTDOWN_TIMER) != null;
        String shutdownType = request.getParameter(PARAM_SHUTDOWN_TYPE);
        if (shutdownType == null) {
            shutdownType = "";
        }
        DateFormat format = DateFormat.getDateTimeInstance(1, 1, request.getLocale());
        String startTime = format.format(new Date(startDate));
        String upTime = VMStatPlugin.formatPeriod(System.currentTimeMillis() - startDate);
        JSONObject json = new JSONObject();
        try {
            json.put("systemStartLevel", this.getStartLevel().getStartLevel());
            json.put("bundleStartLevel", this.getStartLevel().getInitialBundleStartLevel());
            json.put("lastStarted", startTime);
            json.put("upTime", upTime);
            json.put("runtime", VMStatPlugin.sysProp("java.runtime.name") + "(build " + VMStatPlugin.sysProp("java.runtime.version") + ")");
            json.put("jvm", VMStatPlugin.sysProp("java.vm.name") + "(build " + VMStatPlugin.sysProp("java.vm.version") + ", " + VMStatPlugin.sysProp("java.vm.info") + ")");
            json.put("shutdownTimer", shutdownTimer);
            json.put("mem_total", totalMem);
            json.put("mem_free", freeMem);
            json.put("mem_used", usedMem);
            json.put("shutdownType", shutdownType);
            int processors = VMStatPlugin.getAvailableProcessors();
            if (processors > 0) {
                json.put("processors", processors);
            }
        }
        catch (JSONException e) {
            throw new IOException(e.toString());
        }
        DefaultVariableResolver vars = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)request);
        vars.put("startData", json.toString());
        response.getWriter().print(body);
    }

    private static final String sysProp(String name) {
        String ret = System.getProperty(name);
        if (null == ret || ret.length() == 0) {
            ret = "n/a";
        }
        return ret;
    }

    private static final String formatPeriod(long period) {
        Long msecs = new Long(period % 1000L);
        Long secs = new Long(period / 1000L % 60L);
        Long mins = new Long(period / 1000L / 60L % 60L);
        Long hours = new Long(period / 1000L / 60L / 60L % 24L);
        Long days = new Long(period / 1000L / 60L / 60L / 24L);
        return MessageFormat.format("{0,number} '${vmstat.upTime.format.days}' {1,number,00}:{2,number,00}:{3,number,00}.{4,number,000}", days, hours, mins, secs, msecs);
    }

    private final StartLevel getStartLevel() {
        return (StartLevel)this.getService(START_LEVEL_NAME);
    }

    private static final int getAvailableProcessors() {
        try {
            return Runtime.getRuntime().availableProcessors();
        }
        catch (Throwable throwable) {
            return -1;
        }
    }
}

