/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.context;

import com.recalot.common.Helper;
import com.recalot.common.communication.Interaction;
import com.recalot.common.context.UserContext;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.data.DataSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LastVisitedContext
implements UserContext {
    private Map<String, Map<String, Object>> userContext = new HashMap<String, Map<String, Object>>();
    private Map<String, DataSource> dataSources = new HashMap<String, DataSource>();

    public Object getContext(String sourceId, String userId) {
        if (this.dataSources.containsKey(sourceId)) {
            try {
                Interaction[] interactions = this.dataSources.get(sourceId).getInteractions(userId);
                ArrayList<String> lastVisted = new ArrayList<String>();
                for (int i = 0; i < interactions.length && i < 100; ++i) {
                    lastVisted.add(interactions[i].getItemId());
                }
                if (!this.userContext.containsKey(sourceId)) {
                    this.userContext.put(sourceId, new HashMap());
                }
                this.userContext.get(sourceId).put(userId, lastVisted);
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
        return this.userContext.get(sourceId) != null ? this.userContext.get(sourceId).get(userId) : null;
    }

    public void processContext(String sourceId, String userId, Object context) {
        this.processContext(sourceId, userId, context, null);
    }

    public void processContext(String sourceId, String userId, Object context, String type) {
        if (context != null && type != null) {
            if (!this.userContext.containsKey(sourceId)) {
                this.userContext.put(sourceId, new HashMap());
            }
            if (type.equals(Helper.Keys.Context.LastConsumed) && context instanceof ArrayList) {
                ArrayList lastVisited = (ArrayList)context;
                this.userContext.get(sourceId).put(userId, lastVisited);
            } else if (type.equals(Helper.Keys.Context.DataSet) && context instanceof DataSource) {
                this.dataSources.put(sourceId, (DataSource)context);
            }
        }
    }

    public String getKey() {
        return "user-last-visited";
    }

    public String getDescription() {
        return "Returns the last visited items.";
    }

    public void close() throws IOException {
    }

    public Object getContext() {
        return null;
    }
}

