/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.experiments;

import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.rec.Recommender;
import java.util.ArrayList;
import java.util.Map;

public class GlobalAverageRatingRecommender
extends Recommender {
    private String ratingType = "rating".intern();
    private double prediction;
    private RecommendationResult result;

    public void train() throws BaseException {
        int count = 0;
        double sum = 0.0;
        for (Interaction interaction : this.getDataSet().getInteractions()) {
            Integer value;
            if (!interaction.getType().toLowerCase().equals(this.ratingType) || (value = Integer.valueOf(Integer.parseInt(interaction.getValue()))) == null) continue;
            ++count;
            sum += (double)value.intValue();
        }
        this.result = new RecommendationResult(this.getKey(), new ArrayList());
        this.prediction = count > 0 ? sum / (double)count : Double.NaN;
    }

    public RecommendationResult recommend(String userId, ContextProvider context, Map<String, String> param) {
        return this.result;
    }

    public Double predict(String userId, String itemId, ContextProvider context, Map<String, String> param) {
        return this.prediction;
    }
}

