/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.experiments;

import com.recalot.common.Helper;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.rec.Recommender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GlobalUserAverageRatingRecommender
extends Recommender {
    private String ratingType = "rating".intern();
    private HashMap<String, Double> prediction;
    private RecommendationResult result;

    public void train() throws BaseException {
        HashMap count = new HashMap();
        HashMap sum = new HashMap();
        for (Interaction interaction : this.getDataSet().getInteractions()) {
            Integer value;
            if (!interaction.getType().toLowerCase().equals(this.ratingType) || (value = Integer.valueOf(Integer.parseInt(interaction.getValue()))) == null) continue;
            Helper.incrementMapValue(count, (Object)interaction.getUserId());
            Helper.incrementMapValue(sum, (Object)interaction.getUserId(), (Double)(1.0 * (double)value.intValue()));
        }
        this.result = new RecommendationResult(this.getKey(), new ArrayList());
        this.prediction = new HashMap();
        for (String userId : count.keySet()) {
            int c = (Integer)count.get(userId);
            double s = (Double)sum.get(userId);
            if (c <= 0) continue;
            this.prediction.put(userId, s / (double)c);
        }
    }

    public RecommendationResult recommend(String userId, ContextProvider context, Map<String, String> param) {
        return this.result;
    }

    public Double predict(String userId, String itemId, ContextProvider context, Map<String, String> param) {
        return this.prediction.containsKey(userId) ? this.prediction.get(userId) : Double.valueOf(Double.NaN);
    }
}

