/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.funksvd;

import com.recalot.common.Helper;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.communication.User;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.rec.Recommender;
import com.recalot.model.rec.recommender.funksvd.helper.GradientDescentSVD;
import com.recalot.model.rec.recommender.funksvd.helper.RandomUtils;
import com.recalot.model.rec.recommender.helper.RecommenderHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

@Configurations(value={@Configuration(key="numFeatures", type=ConfigurationItem.ConfigurationItemType.Integer, value="50", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional), @Configuration(key="initialSteps", type=ConfigurationItem.ConfigurationItemType.Integer, value="50", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional)})
public class FunkSVDRecommender
extends Recommender {
    int numFeatures = 50;
    int initialSteps = 50;
    private HashMap<String, Integer> userMap = null;
    private HashMap<String, Integer> itemMap = null;
    private HashMap<String, Integer> interactionValueMap = null;
    private GradientDescentSVD emSvd = null;
    private List<Interaction> cachedPreferences = null;
    private static final Random random = RandomUtils.getRandom();

    public FunkSVDRecommender() {
        this.setKey("funksvd");
    }

    public void train(int steps) {
        for (int i = 0; i < steps; ++i) {
            this.nextTrainStep();
        }
    }

    private void nextTrainStep() {
        Collections.shuffle(this.cachedPreferences, random);
        for (int i = 0; i < this.numFeatures; ++i) {
            for (Interaction rating : this.cachedPreferences) {
                if (!this.userMap.containsKey(rating.getUserId()) || !this.itemMap.containsKey(rating.getItemId()) || !this.interactionValueMap.containsKey(rating.getValue())) continue;
                int useridx = this.userMap.get(rating.getUserId());
                int itemidx = this.itemMap.get(rating.getItemId());
                int interactionValue = this.interactionValueMap.get(rating.getValue());
                this.emSvd.train(useridx, itemidx, i, interactionValue);
            }
        }
    }

    public void train() throws BaseException {
        int numUsers = this.getDataSet().getUsersCount();
        this.userMap = new HashMap(numUsers);
        int idx = 0;
        for (User user : this.getDataSet().getUsers()) {
            this.userMap.put(user.getId(), idx++);
        }
        int numItems = this.getDataSet().getItemsCount();
        this.itemMap = new HashMap(numItems);
        idx = 0;
        for (Item item : this.getDataSet().getItems()) {
            this.itemMap.put(item.getId(), idx++);
        }
        this.interactionValueMap = new HashMap();
        for (Item item : this.getDataSet().getInteractions()) {
            if (this.interactionValueMap.containsKey(item.getValue())) continue;
            this.interactionValueMap.put(item.getValue(), Integer.parseInt(item.getValue()));
        }
        double average = RecommenderHelper.getGlobalRatingAverage(this.getDataSet());
        double defaultValue = Math.sqrt((average - 1.0) / (double)this.numFeatures);
        this.emSvd = new GradientDescentSVD(numUsers, numItems, this.numFeatures, defaultValue);
        this.cachedPreferences = new ArrayList<Interaction>();
        this.cachedPreferences.addAll(Arrays.asList(this.getDataSet().getInteractions()));
        this.train(this.initialSteps);
    }

    public RecommendationResult recommend(String userId, ContextProvider context, Map<String, String> param) {
        List<RecommendedItem> items = new ArrayList();
        try {
            List rec = this.recommendItemsByRatingPrediction(userId, true);
            for (String key : rec) {
                items.add(new RecommendedItem(key, 0.0));
            }
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        items = Helper.applySubList(items, param, (int)10);
        return new RecommendationResult(this.getId(), items);
    }

    public Double predict(String userId, String itemId, ContextProvider context, Map<String, String> param) {
        Integer useridx = this.userMap.get(userId);
        Integer itemidx = this.itemMap.get(itemId);
        if (useridx != null) {
            return this.emSvd.getDotProduct(useridx, itemidx);
        }
        return Double.NaN;
    }

    public void setNumFeatures(String n) {
        this.numFeatures = Integer.parseInt(n);
    }

    public void setInitialSteps(String n) {
        this.initialSteps = Integer.parseInt(n);
    }
}

