/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.funksvd.helper;

import com.recalot.model.rec.recommender.funksvd.helper.LongPrimitiveIterator;
import java.util.NoSuchElementException;

public final class LongPrimitiveArrayIterator
implements LongPrimitiveIterator {
    private final long[] array;
    private int position;
    private final int max;

    public LongPrimitiveArrayIterator(long[] array) {
        if (array == null) {
            throw new IllegalArgumentException("array is null");
        }
        this.array = array;
        this.position = 0;
        this.max = array.length;
    }

    @Override
    public boolean hasNext() {
        return this.position < this.max;
    }

    @Override
    public Long next() {
        return this.nextLong();
    }

    @Override
    public long nextLong() {
        if (this.position >= this.array.length) {
            throw new NoSuchElementException();
        }
        return this.array[this.position++];
    }

    @Override
    public long peek() {
        if (this.position >= this.array.length) {
            throw new NoSuchElementException();
        }
        return this.array[this.position];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void skip(int n) {
        if (n > 0) {
            this.position += n;
        }
    }

    public String toString() {
        return "LongPrimitiveArrayIterator";
    }
}

