/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.mostpopular;

import com.recalot.common.Helper;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.rec.Recommender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@Configuration(key="omitViewedItems", type=ConfigurationItem.ConfigurationItemType.Boolean, value="true", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional)
public class MostPopularRecommender
extends Recommender {
    protected RecommendationResult result;
    private boolean omitViewedItems = true;

    public void train() throws BaseException {
        Map count = new LinkedHashMap();
        for (Interaction interaction : this.getDataSet().getInteractions()) {
            Helper.incrementMapValue(count, (Object)interaction.getItemId());
        }
        ArrayList<RecommendedItem> recommendedItems = new ArrayList<RecommendedItem>();
        count = Helper.sortByValueDescending(count);
        double sum = Helper.sum(count).intValue();
        for (String key : count.keySet()) {
            recommendedItems.add(new RecommendedItem(key, 1.0 * (double)((Integer)count.get(key)).intValue() / sum));
        }
        this.result = new RecommendationResult(this.getId(), recommendedItems);
    }

    public RecommendationResult recommend(String userId, ContextProvider context, Map<String, String> param) throws BaseException {
        ArrayList<RecommendedItem> recommendedItems = new ArrayList<RecommendedItem>();
        if (this.omitViewedItems) {
            HashMap<String, Boolean> omitItems = new HashMap<String, Boolean>();
            try {
                Interaction[] userInteractions;
                for (Interaction i : userInteractions = this.getDataSet().getInteractions(userId)) {
                    omitItems.put(i.getItemId(), true);
                }
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
            for (RecommendedItem item : this.result.getItems()) {
                if (omitItems.containsKey(item.getItemId())) continue;
                recommendedItems.add(item);
            }
            return new RecommendationResult(this.getId(), recommendedItems);
        }
        return this.result;
    }

    public Double predict(String userId, String itemId, ContextProvider context, Map<String, String> param) throws BaseException {
        return 0.0;
    }
}

