/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.reddit;

import com.recalot.common.Helper;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.model.rec.recommender.bprmf.BPRMFRecommender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Configuration(key="recommendOnlyItemsTheUserAlreadyViewed", type=ConfigurationItem.ConfigurationItemType.Boolean, value="true", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional)
public class BPRRecommender
extends BPRMFRecommender {
    protected HashMap<String, HashMap<String, Item>> uItems;
    protected ArrayList<Item> filteredItems;
    protected boolean recommendOnlyItemsTheUserAlreadyViewed = false;

    @Override
    public void train() throws BaseException {
        super.train();
        this.uItems = new HashMap();
        this.filteredItems = new ArrayList();
        for (Interaction interaction : this.getDataSet().getInteractions()) {
            String userId = interaction.getUserId();
            if (!this.uItems.containsKey(userId)) {
                this.uItems.put(userId, new HashMap());
            }
            String itemId = interaction.getItemId();
            if (this.uItems.get(userId).containsKey(itemId)) continue;
            this.uItems.get(userId).put(itemId, this.getDataSet().getItem(itemId));
        }
        for (Interaction interaction : this.getDataSet().getItems()) {
            if (interaction.getId().length() <= 2) continue;
            this.filteredItems.add((Item)interaction);
        }
    }

    @Override
    public RecommendationResult recommend(String userId, ContextProvider context, Map<String, String> param) throws BaseException {
        List<RecommendedItem> items = new ArrayList();
        try {
            List rec = this.recommendOnlyItemsTheUserAlreadyViewed ? this.recommendItemsByRatingPrediction(userId, this.uItems.get(userId).values().toArray(new Item[this.uItems.get(userId).values().size()]), true) : this.recommendItemsByRatingPrediction(userId, this.filteredItems.toArray(new Item[this.filteredItems.size()]), true);
            for (String key : rec) {
                items.add(new RecommendedItem(key, 0.0));
            }
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        items = Helper.applySubList(items, param, (int)10);
        return new RecommendationResult(this.getId(), items);
    }

    @Override
    public Double predict(String userId, String itemId, ContextProvider context, Map<String, String> param) throws BaseException {
        return super.predict(userId, itemId, context, param);
    }

    public boolean isRecommendOnlyItemsTheUserAlreadyViewed() {
        return this.recommendOnlyItemsTheUserAlreadyViewed;
    }

    public void setRecommendOnlyItemsTheUserAlreadyViewed(boolean recommendOnlyItemsTheUserAlreadyViewed) {
        this.recommendOnlyItemsTheUserAlreadyViewed = recommendOnlyItemsTheUserAlreadyViewed;
    }
}

