/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.reddit;

import com.recalot.common.Helper;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.rec.Recommender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Configuration(key="recommendOnlyItemsTheUserAlreadyViewed", type=ConfigurationItem.ConfigurationItemType.Boolean, value="true", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional)
public class MostPopularRecommender
extends Recommender {
    protected RecommendationResult result;
    protected HashMap<String, HashMap<String, Item>> uItems;
    protected boolean recommendOnlyItemsTheUserAlreadyViewed = false;

    public void train() throws BaseException {
        Map count = new LinkedHashMap();
        for (Interaction interaction : this.getDataSet().getInteractions()) {
            Helper.incrementMapValue(count, (Object)interaction.getItemId());
        }
        ArrayList<Object> recommendedItems = new ArrayList<Object>();
        count = Helper.sortByValueDescending(count);
        double sum = Helper.sum(count).intValue();
        for (String key : count.keySet()) {
            if (key.length() <= 2) continue;
            recommendedItems.add(new RecommendedItem(key, 1.0 * (double)((Integer)count.get(key)).intValue() / sum));
        }
        ArrayList<RecommendedItem> remainingItems = new ArrayList<RecommendedItem>();
        for (Item item : this.getDataSet().getItems()) {
            if (recommendedItems.stream().anyMatch(i -> i.getItemId().equals(item.getId()))) continue;
            remainingItems.add(new RecommendedItem(item.getId(), 0.0));
        }
        recommendedItems.addAll(remainingItems);
        this.uItems = new HashMap();
        for (Item item : this.getDataSet().getInteractions()) {
            String userId = item.getUserId();
            if (!this.uItems.containsKey(userId)) {
                this.uItems.put(userId, new HashMap());
            }
            String itemId = item.getItemId();
            if (this.uItems.get(userId).containsKey(itemId)) continue;
            this.uItems.get(userId).put(itemId, this.getDataSet().getItem(itemId));
        }
        this.result = new RecommendationResult(this.getId(), recommendedItems);
    }

    public RecommendationResult recommend(String userId, ContextProvider context, Map<String, String> param) throws BaseException {
        List<RecommendedItem> items = null;
        if (this.result != null) {
            List temp = this.result.getItems();
            if (this.recommendOnlyItemsTheUserAlreadyViewed) {
                items = new ArrayList();
                for (RecommendedItem item : temp) {
                    if (!this.uItems.get(userId).containsKey(item.getItemId())) continue;
                    items.add(item);
                }
            } else {
                items = temp;
            }
        }
        if (items == null) {
            items = new ArrayList();
        }
        return new RecommendationResult(this.getId(), items);
    }

    public Double predict(String userId, String itemId, ContextProvider context, Map<String, String> param) throws BaseException {
        return 0.0;
    }

    public boolean isRecommendOnlyItemsTheUserAlreadyViewed() {
        return this.recommendOnlyItemsTheUserAlreadyViewed;
    }

    public void setRecommendOnlyItemsTheUserAlreadyViewed(boolean recommendOnlyItemsTheUserAlreadyViewed) {
        this.recommendOnlyItemsTheUserAlreadyViewed = recommendOnlyItemsTheUserAlreadyViewed;
    }
}

