/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.reddit;

import com.recalot.common.communication.Item;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.rec.Recommender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Configuration(key="recommendOnlyItemsTheUserAlreadyViewed", type=ConfigurationItem.ConfigurationItemType.Boolean, value="true", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional)
public class RandomRecommender
extends Recommender {
    protected List<RecommendedItem> recommendedItems;
    protected HashMap<String, HashMap<String, Item>> uItems;
    protected boolean recommendOnlyItemsTheUserAlreadyViewed = false;

    public void train() throws BaseException {
        this.recommendedItems = new ArrayList<RecommendedItem>();
        for (Item item : this.getDataSet().getItems()) {
            if (item.getId().length() <= 2) continue;
            this.recommendedItems.add(new RecommendedItem(item, 0.0));
        }
        this.uItems = new HashMap();
        for (Item item : this.getDataSet().getInteractions()) {
            String userId = item.getUserId();
            if (!this.uItems.containsKey(userId)) {
                this.uItems.put(userId, new HashMap());
            }
            String itemId = item.getItemId();
            if (this.uItems.get(userId).containsKey(itemId)) continue;
            this.uItems.get(userId).put(itemId, this.getDataSet().getItem(itemId));
        }
    }

    public RecommendationResult recommend(String userId, ContextProvider context, Map<String, String> param) throws BaseException {
        ArrayList<Object> items;
        ArrayList<RecommendedItem> temp = new ArrayList<RecommendedItem>(this.recommendedItems);
        Collections.shuffle(temp);
        if (this.recommendOnlyItemsTheUserAlreadyViewed) {
            items = new ArrayList();
            for (RecommendedItem item : temp) {
                if (!this.uItems.get(userId).containsKey(item.getItemId())) continue;
                items.add(item);
            }
        } else {
            items = temp;
        }
        return new RecommendationResult(this.getId(), items);
    }

    public Double predict(String userId, String itemId, ContextProvider context, Map<String, String> param) throws BaseException {
        return 0.0;
    }

    public boolean isRecommendOnlyItemsTheUserAlreadyViewed() {
        return this.recommendOnlyItemsTheUserAlreadyViewed;
    }

    public void setRecommendOnlyItemsTheUserAlreadyViewed(boolean recommendOnlyItemsTheUserAlreadyViewed) {
        this.recommendOnlyItemsTheUserAlreadyViewed = recommendOnlyItemsTheUserAlreadyViewed;
    }
}

