/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.wallpaper.mostpopular;

import com.recalot.common.Helper;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.rec.Recommender;
import flexjson.JSONDeserializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MostPopularRecommender
extends Recommender {
    private RecommendationResult result;

    public void train() throws BaseException {
        Map count = new LinkedHashMap();
        for (Interaction interaction : this.getDataSet().getInteractions()) {
            if (!interaction.getType().toLowerCase().equals("rating")) continue;
            Helper.incrementMapValue(count, (Object)interaction.getItemId(), (Integer)Integer.parseInt(interaction.getValue()));
        }
        for (Item item : this.getDataSet().getItems()) {
            String content = item.getValue("content");
            if (content == null || content.isEmpty()) continue;
            try {
                HashMap itemContent = (HashMap)new JSONDeserializer().deserialize(content);
                String rating = (String)itemContent.get("Rating");
                String ratingCount = (String)itemContent.get("RatingCount");
                if (rating == null || rating.isEmpty() || ratingCount == null || ratingCount.isEmpty()) continue;
                Double r = Double.parseDouble(rating);
                Integer c = Integer.parseInt(ratingCount.replace("(", "").replace(" vote)", "").replace(" votes)", ""));
                Helper.incrementMapValue(count, (Object)item.getId(), (Integer)((int)Math.round(r * (double)c.intValue())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<Object> recommendedItems = new ArrayList<Object>();
        count = Helper.sortByValueDescending(count);
        double sum = Helper.sum(count).intValue();
        for (String key : count.keySet()) {
            recommendedItems.add(new RecommendedItem(this.getDataSet().getItem(key), 1.0 * (double)((Integer)count.get(key)).intValue() / sum));
        }
        ArrayList<RecommendedItem> remainingItems = new ArrayList<RecommendedItem>();
        for (Item item : this.getDataSet().getItems()) {
            if (recommendedItems.stream().anyMatch(i -> i.getItemId().equals(item.getId()))) continue;
            remainingItems.add(new RecommendedItem(item, 0.0));
        }
        recommendedItems.addAll(remainingItems);
        this.result = new RecommendationResult(this.getId(), Helper.applySubList(recommendedItems, (int)10));
    }

    public RecommendationResult recommend(String userId, ContextProvider context, Map<String, String> param) {
        ArrayList items = null;
        if (this.result != null) {
            items = this.result.getItems();
        }
        if (items == null) {
            items = new ArrayList();
        }
        return new RecommendationResult(this.getId(), items);
    }

    public Double predict(String userId, String itemId, ContextProvider context, Map<String, String> param) {
        return 0.0;
    }
}

