/*
 * Decompiled with CFR 0.152.
 */
package librec.ext;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Map;
import librec.data.SparseVector;
import librec.data.VectorEntry;
import librec.intf.Recommender;

public class AR
extends Recommender {
    private Table<Integer, Integer, Double> A;

    public AR() {
        this.isRankingPred = true;
    }

    @Override
    public void initModel() throws Exception {
        super.initModel();
        this.A = HashBasedTable.create((int)this.numItems, (int)this.numItems);
        this.userCache = this.trainMatrix.rowCache(this.guavaCacheSpec);
    }

    @Override
    public void buildModel() throws Exception {
        for (int x = 0; x < this.numItems; ++x) {
            SparseVector qx = this.trainMatrix.column(x);
            int total = qx.getCount();
            for (int y = 0; y < this.numItems; ++y) {
                int count = 0;
                for (VectorEntry ve : qx) {
                    int u = ve.index();
                    double ruy = this.trainMatrix.get(u, y);
                    if (!(ruy > 0.0)) continue;
                    ++count;
                }
                if (count <= 0) continue;
                double conf = ((double)count + 0.0) / (double)total;
                this.A.put((Object)x, (Object)y, (Object)conf);
            }
        }
    }

    @Override
    public double ranking(int u, int j) throws Exception {
        SparseVector pu = (SparseVector)this.userCache.get((Object)u);
        double rank = 0.0;
        for (Map.Entry en : this.A.column((Object)j).entrySet()) {
            int i = (Integer)en.getKey();
            double support = (Double)en.getValue();
            rank += pu.get(i) * support;
        }
        return rank;
    }
}

