/*
 * Decompiled with CFR 0.152.
 */
package librec.intf;

import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.intf.Recommender;

@Configurations(value={@Configuration(key="isBoldDriver", value="true", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Boolean), @Configuration(key="numFactors", value="100", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Integer), @Configuration(key="numIters", value="100", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Integer), @Configuration(key="lRate", value="0.005", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double), @Configuration(key="maxLRate", value="-1", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double), @Configuration(key="decay", value="-1.0", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double), @Configuration(key="regI", value="0.1", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double), @Configuration(key="regU", value="0.1", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double), @Configuration(key="regB", value="0.1", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double), @Configuration(key="reg", value="0.1", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double)})
public abstract class IterativeRecommender
extends Recommender {
    public double maxLRate;
    public int numFactors;
    public boolean isBoldDriver;
    public int numIters;
    public double regU;
    public double regI;
    public double regB;
    public double reg;
    public float decay;
    public static boolean resetStatics = true;
    protected DenseMatrix P;
    protected DenseMatrix Q;
    protected DenseVector userBias;
    protected DenseVector itemBias;
    public double lRate;
    public double loss;
    public double last_loss = 0.0;
    public double measure;
    public double last_measure = 0.0;
    protected boolean initByNorm = true;

    @Override
    public double predict(int u, int j) throws Exception {
        return DenseMatrix.rowMult(this.P, u, this.Q, j);
    }

    protected boolean isConverged(int iter) throws Exception {
        boolean converged;
        float delta_measure = (float)(this.last_measure - this.measure);
        if (Double.isNaN(this.loss) || Double.isInfinite(this.loss)) {
            // empty if block
        }
        boolean cond1 = Math.abs(this.loss) < 1.0E-5;
        boolean cond2 = delta_measure > 0.0f && (double)delta_measure < 1.0E-5;
        boolean bl = converged = cond1 || cond2;
        if (!converged) {
            this.updateLRate(iter);
        }
        this.last_loss = this.loss;
        this.last_measure = this.measure;
        return converged;
    }

    protected void updateLRate(int iter) {
        if (this.lRate <= 0.0) {
            return;
        }
        if (this.isBoldDriver && iter > 1) {
            this.lRate = Math.abs(this.last_loss) > Math.abs(this.loss) ? this.lRate * 1.05 : this.lRate * 0.5;
        } else if (this.decay > 0.0f && this.decay < 1.0f) {
            this.lRate *= (double)this.decay;
        }
        if (this.maxLRate > 0.0 && this.lRate > this.maxLRate) {
            this.lRate = this.maxLRate;
        }
    }

    @Override
    public void initModel() throws Exception {
        this.P = new DenseMatrix(this.numUsers, this.numFactors);
        this.Q = new DenseMatrix(this.numItems, this.numFactors);
        if (this.initByNorm) {
            this.P.init(this.initMean, this.initStd);
            this.Q.init(this.initMean, this.initStd);
        } else {
            this.P.init();
            this.Q.init();
        }
    }
}

