/*
 * Decompiled with CFR 0.152.
 */
package librec.rating;

import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.MatrixEntry;
import librec.intf.IterativeRecommender;

public class BiasedMF
extends IterativeRecommender {
    @Override
    public void initModel() throws Exception {
        super.initModel();
        this.userBias = new DenseVector(this.numUsers);
        this.itemBias = new DenseVector(this.numItems);
        this.userBias.init(this.initMean, this.initStd);
        this.itemBias.init(this.initMean, this.initStd);
    }

    @Override
    public void buildModel() throws Exception {
        for (int iter = 1; iter <= this.numIters; ++iter) {
            this.loss = 0.0;
            for (MatrixEntry me : this.trainMatrix) {
                int u = me.row();
                int j = me.column();
                double ruj = me.get();
                double pred = this.predict(u, j, false);
                double euj = ruj - pred;
                this.loss += euj * euj;
                double bu = this.userBias.get(u);
                double sgd = euj - this.regB * bu;
                this.userBias.add(u, this.lRate * sgd);
                this.loss += this.regB * bu * bu;
                double bj = this.itemBias.get(j);
                sgd = euj - this.regB * bj;
                this.itemBias.add(j, this.lRate * sgd);
                this.loss += this.regB * bj * bj;
                for (int f = 0; f < this.numFactors; ++f) {
                    double puf = this.P.get(u, f);
                    double qjf = this.Q.get(j, f);
                    double delta_u = euj * qjf - this.regU * puf;
                    double delta_j = euj * puf - this.regI * qjf;
                    this.P.add(u, f, this.lRate * delta_u);
                    this.Q.add(j, f, this.lRate * delta_j);
                    this.loss += this.regU * puf * puf + this.regI * qjf * qjf;
                }
            }
            this.loss *= 0.5;
            if (this.isConverged(iter)) break;
        }
    }

    @Override
    public double predict(int u, int j) throws Exception {
        return this.globalMean + this.userBias.get(u) + this.itemBias.get(j) + DenseMatrix.rowMult(this.P, u, this.Q, j);
    }
}

