/*
 * Decompiled with CFR 0.152.
 */
package librec.rating;

import librec.data.DenseMatrix;
import librec.data.TensorEntry;
import librec.intf.TensorRecommender;

public class CPTF
extends TensorRecommender {
    private DenseMatrix[] M;

    @Override
    public void initModel() throws Exception {
        this.M = new DenseMatrix[this.numDimensions];
        for (int d = 0; d < this.numDimensions; ++d) {
            this.M[d] = new DenseMatrix(this.dimensions[d], this.numFactors);
            this.M[d].init(this.smallValue);
            this.normalize(d);
        }
    }

    protected void normalize(int d) {
        for (int f = 0; f < this.numFactors; ++f) {
            int r;
            double norm = 0.0;
            for (r = 0; r < this.M[d].numRows(); ++r) {
                norm += Math.pow(this.M[d].get(r, f), 2.0);
            }
            norm = Math.sqrt(norm);
            for (r = 0; r < this.M[d].numRows(); ++r) {
                this.M[d].set(r, f, this.M[d].get(r, f) / norm);
            }
        }
    }

    @Override
    public void buildModel() throws Exception {
        for (int iter = 1; iter < this.numIters; ++iter) {
            int d;
            DenseMatrix[] Ms = new DenseMatrix[this.numDimensions];
            for (d = 0; d < this.numDimensions; ++d) {
                Ms[d] = new DenseMatrix(this.dimensions[d], this.numFactors);
            }
            this.loss = 0.0;
            for (TensorEntry te : this.trainTensor) {
                int[] keys = te.keys();
                double rate = te.get();
                if (rate <= 0.0) continue;
                double pred = this.predict(keys);
                double e = rate - pred;
                this.loss += e * e;
                for (int d2 = 0; d2 < this.numDimensions; ++d2) {
                    for (int f = 0; f < this.numFactors; ++f) {
                        double sgd = 1.0;
                        for (int dd = 0; dd < this.numDimensions; ++dd) {
                            if (dd == d2) continue;
                            sgd *= this.M[dd].get(keys[dd], f);
                        }
                        Ms[d2].add(keys[d2], f, sgd * e);
                    }
                }
            }
            for (d = 0; d < this.numDimensions; ++d) {
                for (int r = 0; r < this.M[d].numRows(); ++r) {
                    for (int c = 0; c < this.M[d].numColumns(); ++c) {
                        double Mrc = this.M[d].get(r, c);
                        this.M[d].add(r, c, this.lRate * (Ms[d].get(r, c) - this.reg * Mrc));
                        this.loss += this.reg * Mrc * Mrc;
                    }
                }
            }
            this.loss *= 0.5;
            if (this.isConverged(iter)) break;
        }
    }

    @Override
    public double predict(int[] keys) {
        double pred = 0.0;
        for (int f = 0; f < this.numFactors; ++f) {
            double prod = 1.0;
            for (int d = 0; d < this.numDimensions; ++d) {
                prod *= this.M[d].get(keys[d], f);
            }
            pred += prod;
        }
        return pred;
    }
}

