/*
 * Decompiled with CFR 0.152.
 */
package flexjson;

import flexjson.BeanAnalyzer;
import flexjson.JSON;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BeanProperty {
    private String name;
    private BeanAnalyzer bean;
    private Class propertyType;
    protected Field property;
    protected Method readMethod;
    protected Method writeMethod;
    protected Map<Class<?>, Method> writeMethods = new HashMap();

    public BeanProperty(String name, BeanAnalyzer bean) {
        this.name = name;
        this.bean = bean;
        this.property = bean.getDeclaredField(name);
    }

    public BeanProperty(Field property, BeanAnalyzer bean) {
        this.name = property.getName();
        this.bean = bean;
        this.property = property;
        this.propertyType = property.getType();
    }

    public String getName() {
        return this.name;
    }

    public Field getProperty() {
        return this.property;
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public Method getReadMethod() {
        if (this.readMethod == null && this.bean.getSuperBean() != null && this.bean.getSuperBean().hasProperty(this.name)) {
            return this.bean.getSuperBean().getProperty(this.name).getReadMethod();
        }
        return this.readMethod;
    }

    public Method getWriteMethod() {
        if (this.writeMethod == null) {
            this.writeMethod = this.writeMethods.get(this.propertyType);
            if (this.writeMethod == null && this.bean.getSuperBean() != null && this.bean.getSuperBean().hasProperty(this.name)) {
                return this.bean.getSuperBean().getProperty(this.name).getWriteMethod();
            }
        }
        return this.writeMethod;
    }

    public Collection<Method> getWriteMethods() {
        return this.writeMethods.values();
    }

    public void addWriteMethod(Method method) {
        Class<?> clazz = method.getParameterTypes()[0];
        if (this.propertyType == null) {
            this.propertyType = clazz;
        }
        this.writeMethods.put(clazz, method);
        method.setAccessible(true);
    }

    public void setReadMethod(Method method) {
        if (this.propertyType == null) {
            this.propertyType = method.getReturnType();
            this.readMethod = method;
            this.readMethod.setAccessible(true);
        } else if (this.propertyType == method.getReturnType()) {
            this.readMethod = method;
            this.readMethod.setAccessible(true);
        }
    }

    public Boolean isAnnotated() {
        Method rm = this.getReadMethod();
        if (rm != null) {
            if (rm.isAnnotationPresent(JSON.class)) {
                return rm.getAnnotation(JSON.class).include();
            }
        } else if (this.property != null && this.property.isAnnotationPresent(JSON.class)) {
            return this.property.getAnnotation(JSON.class).include();
        }
        return null;
    }

    public Object getValue(Object instance) throws InvocationTargetException, IllegalAccessException {
        Method rm = this.getReadMethod();
        if (rm != null) {
            return rm.invoke(instance, (Object[])null);
        }
        if (this.property != null) {
            return this.property.get(instance);
        }
        return null;
    }

    public Boolean isReadable() {
        Method rm = this.getReadMethod();
        return rm != null && !Modifier.isStatic(rm.getModifiers()) || this.property != null && !Modifier.isStatic(this.property.getModifiers()) && !Modifier.isTransient(this.property.getModifiers());
    }

    public Boolean isWritable() {
        Method wm = this.getWriteMethod();
        return wm != null && Modifier.isPublic(wm.getModifiers()) || this.property != null && Modifier.isPublic(this.property.getModifiers()) && !Modifier.isTransient(this.property.getModifiers());
    }
}

