/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.helper.matrix;

import com.recalot.model.rec.recommender.helper.matrix.SparseMatrix;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntIntProcedure;
import gnu.trove.procedure.TIntObjectProcedure;
import java.io.Serializable;

public class SparseIntMatrix
implements Serializable,
SparseMatrix<Integer> {
    private static final long serialVersionUID = -6478156641138087976L;
    TIntObjectMap<TIntIntMap> matrix = new TIntObjectHashMap<TIntIntMap>();
    private int M;
    private int N;
    private int numberOfEntries;

    public SparseIntMatrix() {
        this.numberOfEntries = 0;
    }

    public SparseIntMatrix(int m, int n) {
        this.M = m;
        this.N = n;
        this.numberOfEntries = 0;
    }

    @Override
    public void set(int i, int j, Integer b) {
        TIntIntMap row = this.matrix.get(i);
        if (row == null) {
            if (b == 0) {
                return;
            }
            row = new TIntIntHashMap();
            this.matrix.put(i, row);
        }
        if (b == 0) {
            if (row.get(j) == 0) {
                return;
            }
            row.remove(j);
            --this.numberOfEntries;
        } else {
            row.put(j, b);
            ++this.numberOfEntries;
        }
    }

    @Override
    public void setBool(int i, int j, boolean b) {
        if (b) {
            this.set(i, j, 1);
        } else {
            this.set(i, j, 0);
        }
    }

    @Override
    public Integer get(int i, int j) {
        TIntIntMap row = this.matrix.get(i);
        if (row != null) {
            int value = row.get(j);
            return value;
        }
        return 0;
    }

    @Override
    public boolean getBool(int i, int j) {
        TIntIntMap row = this.matrix.get(i);
        if (row != null) {
            int value = row.get(j);
            return value != 0;
        }
        return false;
    }

    @Override
    public TIntIntMap getRow(int i) {
        return this.matrix.get(i);
    }

    public SparseIntMatrix copy() {
        SparseIntMatrix copy = new SparseIntMatrix();
        OuterRunner outerRunner = new OuterRunner(copy);
        this.matrix.forEachEntry(outerRunner);
        return copy;
    }

    @Override
    public int getM() {
        return this.M;
    }

    @Override
    public int getN() {
        return this.N;
    }

    @Override
    public String getType() {
        return "int";
    }

    @Override
    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    private class InnerRunner
    implements TIntIntProcedure {
        SparseIntMatrix copy;
        int i;

        InnerRunner(SparseIntMatrix copy, int i) {
            this.copy = copy;
            this.i = i;
        }

        @Override
        public boolean execute(int j, int b) {
            this.copy.set(this.i, j, b);
            return true;
        }
    }

    private class OuterRunner
    implements TIntObjectProcedure<TIntIntMap> {
        SparseIntMatrix copy;

        OuterRunner(SparseIntMatrix copy) {
            this.copy = copy;
        }

        @Override
        public boolean execute(int i, TIntIntMap row) {
            InnerRunner innerRunner = new InnerRunner(this.copy, i);
            return row.forEachEntry(innerRunner);
        }
    }
}

