/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.reddit;

import com.recalot.common.communication.DataSet;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.context.UserContext;
import com.recalot.common.exceptions.BaseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ContextHelper {
    private String dataSourceId;
    private HashMap<String, HashMap<String, Boolean>> coocurence;

    public ContextHelper(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public List<RecommendedItem> applyBothContext(List<RecommendedItem> items, String userId, UserContext context, UserContext lastItemContext) throws BaseException {
        Object c = context.getContext(this.getDataSourceId(), userId);
        Object c2 = lastItemContext.getContext(this.getDataSourceId(), userId);
        if (c != null && c instanceof String && c2 != null && c2 instanceof ArrayList) {
            String letter = (String)c;
            ArrayList<RecommendedItem> resultBothMatches = new ArrayList<RecommendedItem>();
            ArrayList<RecommendedItem> result1Match = new ArrayList<RecommendedItem>();
            ArrayList<RecommendedItem> resultNoMatch = new ArrayList<RecommendedItem>();
            ArrayList lastItems = (ArrayList)c2;
            String lastItemId = null;
            if (lastItems.size() > 0) {
                lastItemId = ((String)lastItems.get(lastItems.size() - 1)).toLowerCase();
            }
            for (RecommendedItem item : items) {
                String itemId = item.getItemId().toLowerCase();
                int match = 0;
                if (item.getItemId().toLowerCase().startsWith(letter)) {
                    ++match;
                }
                if (lastItemId != null && this.coocurence.get(lastItemId).containsKey(itemId)) {
                    ++match;
                }
                switch (match) {
                    case 2: {
                        resultBothMatches.add(item);
                        break;
                    }
                    case 1: {
                        result1Match.add(item);
                        break;
                    }
                    case 0: {
                        resultNoMatch.add(item);
                    }
                }
            }
            ArrayList<RecommendedItem> result = new ArrayList<RecommendedItem>();
            result.addAll(resultBothMatches);
            result.addAll(result1Match);
            result.addAll(resultNoMatch);
            return result;
        }
        return items;
    }

    public List<RecommendedItem> applyLastWordsContext(List<RecommendedItem> items, String userId, UserContext context) throws BaseException {
        Object c = context.getContext(this.getDataSourceId(), userId);
        if (c != null && c instanceof ArrayList) {
            ArrayList lastItems = (ArrayList)c;
            ArrayList<RecommendedItem> result = new ArrayList<RecommendedItem>();
            if (lastItems.size() > 0) {
                String lastItemId = ((String)lastItems.get(lastItems.size() - 1)).toLowerCase();
                if (this.coocurence.containsKey(lastItemId)) {
                    for (RecommendedItem item : items) {
                        String itemId = item.getItemId().toLowerCase();
                        if (!this.coocurence.get(lastItemId).containsKey(itemId)) continue;
                        result.add(item);
                    }
                }
                return result;
            }
        }
        return items;
    }

    public List<RecommendedItem> applyLetterContext(List<RecommendedItem> items, String userId, UserContext context) throws BaseException {
        Object c = context.getContext(this.getDataSourceId(), userId);
        if (c != null && c instanceof String) {
            String letter = (String)c;
            ArrayList<RecommendedItem> result = new ArrayList<RecommendedItem>();
            for (RecommendedItem item : items) {
                if (!item.getItemId().toLowerCase().startsWith(letter)) continue;
                result.add(item);
            }
            return result;
        }
        return items;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void train(DataSet dataSet) {
        this.coocurence = new HashMap();
        String last = null;
        try {
            for (Interaction interaction : dataSet.getInteractions()) {
                String current = interaction.getItemId().toLowerCase();
                if (last != null) {
                    if (!this.coocurence.containsKey(last)) {
                        this.coocurence.put(last, new HashMap());
                    }
                    if (!this.coocurence.get(last).containsKey(current)) {
                        this.coocurence.get(last).put(current, true);
                    }
                }
                last = current;
            }
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
    }
}

