/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.common;

import com.recalot.common.communication.Service;
import com.recalot.common.exceptions.NotFoundException;
import com.recalot.common.log.LogTracker;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class GenericServiceListener<T extends Service>
implements ServiceListener {
    private BundleContext context;
    private final Map<String, T> instances;
    private String className;
    private LogTracker logger;

    public GenericServiceListener(BundleContext context, String className) {
        this.context = context;
        this.instances = new LinkedHashMap<String, T>();
        this.logger = new LogTracker(context);
        this.className = className;
        this.initialize();
    }

    private void initialize() {
        try {
            ServiceReference[] references = this.context.getServiceReferences(this.className, null);
            if (references != null) {
                for (ServiceReference ref : references) {
                    Service instance = (Service)this.context.getService(ref);
                    this.addInstance(instance.getKey(), instance);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            this.logger.log(1, e.getMessage());
        }
    }

    public void serviceChanged(ServiceEvent event) {
        String[] objectClass = (String[])event.getServiceReference().getProperty("objectClass");
        if (this.className.equals(objectClass[0])) {
            Service instance = (Service)this.context.getService(event.getServiceReference());
            if (event.getType() == 1) {
                this.addInstance(instance.getKey(), instance);
            } else if (event.getType() == 4) {
                this.removeInstance(instance.getKey());
            } else if (event.getType() == 2) {
                this.updateInstance(instance.getKey(), instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getFirstInstance() {
        Map<String, T> map = this.instances;
        synchronized (map) {
            if (this.instances.values().size() > 0) {
                return (T)((Service)this.instances.values().toArray()[0]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getInstance(String key) throws NotFoundException {
        Map<String, T> map = this.instances;
        synchronized (map) {
            if (this.instances.containsKey(key)) {
                return (T)((Service)this.instances.get(key));
            }
        }
        throw new NotFoundException("Service instance for key %s and class %s cannot be found.", key, this.className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInstance(String key, T instance) {
        Map<String, T> map = this.instances;
        synchronized (map) {
            this.instances.put(key, instance);
            this.logger.log(3, "Update " + this.className + " with key " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInstance(String key) {
        Map<String, T> map = this.instances;
        synchronized (map) {
            if (!this.instances.containsKey(key)) {
                this.instances.remove(key);
            }
            this.logger.log(3, "Remove " + this.className + " with key " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstance(String key, T instance) {
        Map<String, T> map = this.instances;
        synchronized (map) {
            if (!this.instances.containsKey(key)) {
                this.instances.put(key, instance);
            }
            this.logger.log(3, "Add " + this.className + " with key " + key);
        }
    }

    public ArrayList<T> getAll() {
        return new ArrayList<T>(this.instances.values());
    }
}

