/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.common.builder;

import com.recalot.common.builder.Initiator;
import com.recalot.common.communication.Service;
import com.recalot.common.configuration.Configurable;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.exceptions.BaseException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;

public class InstanceBuilder<T>
extends Configurable
implements Service {
    private Initiator initiator;
    private String className;
    private String key;
    private String description;

    public InstanceBuilder(Initiator initiator, String className, String key, String description) throws BaseException {
        this.initiator = initiator;
        this.className = className;
        this.key = key;
        this.description = description;
    }

    public T createInstance(String id, Map<String, String> params) throws BaseException {
        return this.createInstance(id, "", params);
    }

    public T createInstance(String id, String configPrefix, Map<String, String> params) throws BaseException {
        this.checkConfiguration(configPrefix + (configPrefix == null || configPrefix.isEmpty() ? "" : "."), params);
        try {
            Object instance = this.initiator.createInstance(this.className);
            Class<?> c = instance.getClass();
            Method idm = InstanceBuilder.getMethod(c, "setId", String.class);
            if (idm != null) {
                idm.invoke(instance, id);
            }
            InstanceBuilder.applyConfiguration(instance, c, this.getConfiguration());
            return (T)instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public ConfigurationItem[] getConfiguration() {
        return super.getConfiguration();
    }
}

