/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.common.communication;

import com.recalot.common.communication.InnerIds;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Relation
implements Serializable {
    private int fromId;
    private int toId;
    private int id;
    private int type;
    private Map<Integer, String> content;

    public Relation(String id, String fromId, String toId, String type) {
        this(id, fromId, toId, type, new HashMap<String, String>());
    }

    public Relation(String id, String fromId, String toId, String type, Map<String, String> content) {
        this.id = InnerIds.getNextId(id);
        this.fromId = InnerIds.getNextId(fromId);
        this.toId = InnerIds.getNextId(toId);
        this.type = InnerIds.getNextId(type);
        this.content = new HashMap<Integer, String>();
        for (String key : content.keySet()) {
            int contentId = InnerIds.getNextId(key);
            this.content.put(contentId, content.get(key));
        }
    }

    public String getId() {
        return InnerIds.getId(this.id);
    }

    public String getType() {
        return InnerIds.getId(this.type);
    }

    public Map<String, String> getContent() {
        HashMap<String, String> content = new HashMap<String, String>();
        for (Integer key : this.content.keySet()) {
            String contentKey = InnerIds.getId(key);
            content.put(contentKey, this.content.get(key));
        }
        return content;
    }

    public String getValue(String key) {
        return this.content.get(InnerIds.getId(key));
    }

    public String getToId() {
        return InnerIds.getId(this.toId);
    }

    public String getFromId() {
        return InnerIds.getId(this.fromId);
    }
}

