/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.common.impl.experiment;

import com.recalot.common.Helper;
import com.recalot.common.Parallel;
import com.recalot.common.communication.DataSet;
import com.recalot.common.communication.FillableDataSet;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.communication.User;
import com.recalot.common.context.Context;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.context.UserContext;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.data.DataSource;
import com.recalot.common.interfaces.model.experiment.DataSplitter;
import com.recalot.common.interfaces.model.experiment.Experiment;
import com.recalot.common.interfaces.model.experiment.ListMetric;
import com.recalot.common.interfaces.model.experiment.Metric;
import com.recalot.common.interfaces.model.experiment.RatingMetric;
import com.recalot.common.interfaces.model.rec.Recommender;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Experiment
extends com.recalot.common.interfaces.model.experiment.Experiment {
    private final HashMap<String, Metric[]> metrics;
    private final DataSource dataSource;
    private final DataSplitter splitter;
    private final boolean runThroughAllItems;
    private ContextProvider context;
    private Map<String, String> param;
    private int maxRelevantItemCount = Integer.MAX_VALUE;

    public Experiment(String id, DataSource source, DataSplitter splitter, Recommender[] recommenders, HashMap<String, Metric[]> metrics, ContextProvider context, Map<String, String> param) {
        this.context = context;
        this.param = param;
        this.id = id;
        this.recommenders = recommenders;
        this.recommenderIds = new String[this.recommenders.length];
        for (int i = 0; i < recommenders.length; ++i) {
            this.recommenderIds[i] = recommenders[i].getId();
        }
        this.dataSourceId = source.getId();
        this.dataSource = source;
        this.splitter = splitter;
        this.metrics = metrics;
        this.result = new HashMap();
        boolean bl = this.runThroughAllItems = param != null && param.containsKey("runThroughAllItems") && param.get("runThroughAllItems").equals("true");
        if (param != null && param.containsKey("maxRelevantItemCount")) {
            try {
                Integer result = Integer.parseInt(param.get("maxRelevantItemCount"));
                if (result != null && result >= 1) {
                    this.maxRelevantItemCount = result;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setState(Experiment.ExperimentState.WAITING);
    }

    @Override
    public void run() {
        this.setState(Experiment.ExperimentState.RUNNING);
        this.resetPercentage();
        this.setInfo("Split data source");
        try {
            DataSet[] sets = this.splitter.split(this.dataSource);
            if (!this.param.containsKey(Helper.Keys.SplitType) || this.param.get(Helper.Keys.SplitType).equals("simple")) {
                this.setInfo("Started training recommenders with first split");
                this.trainRecommenders(sets[0]);
                this.addPercentage(50.0);
                this.setInfo("Started testing of the recommenders with second split");
                this.performTest(this.recommenders, sets[1], 50.0 / (double)this.recommenders.length);
            } else if (this.param.get(Helper.Keys.SplitType).equals("n-fold")) {
                double percentageSteps = 100.0 / (double)(this.recommenders.length * sets.length * 2);
                for (int i = 0; i < sets.length; ++i) {
                    this.setInfo(String.format("Started training recommenders with split %s", i));
                    DataSet trainDataSet = FillableDataSet.createDataSet(this.dataSource.getDataSet(), sets[i].getInteractions());
                    this.trainRecommenders(trainDataSet);
                    this.addPercentage((double)this.recommenders.length * percentageSteps);
                    this.performTest(this.recommenders, sets[i], percentageSteps);
                }
            }
        }
        catch (BaseException e) {
            this.setInfo(e.getMessage());
        }
        this.setPercentage(100.0);
        this.setInfo("Done");
        this.setState(Experiment.ExperimentState.FINISHED);
        this.recommenders = null;
    }

    private void performTest(Recommender[] recommenders, DataSet test, double percentage) {
        for (Recommender r : recommenders) {
            this.setInfo(String.format("Evaluate trained recommender %s", r.getId()));
            try {
                User[] users = test.getUsers();
                boolean hasRatingMetric = false;
                for (Metric m : this.metrics.get(r.getId())) {
                    if (!(m instanceof RatingMetric)) continue;
                    hasRatingMetric = true;
                }
                boolean allItems = this.runThroughAllItems;
                boolean hasRating = hasRatingMetric;
                double percentagePerUser = percentage / (double)users.length;
                Parallel.For(Arrays.asList(users), u -> {
                    ArrayList<Object> userInteractions = new ArrayList();
                    try {
                        Interaction[] interactions = test.getInteractions(u.getId());
                        userInteractions = new ArrayList<Interaction>(Arrays.asList(interactions));
                        Collections.sort(userInteractions, (a2, a1) -> a2.getTimeStamp().compareTo(a1.getTimeStamp()));
                    }
                    catch (BaseException e) {
                        e.printStackTrace();
                        this.logger.log(1, e.getMessage());
                    }
                    if (allItems || hasRating) {
                        for (int i = 0; i < userInteractions.size(); ++i) {
                            if (hasRating) {
                                Double predict = 0.0;
                                Integer n = Integer.parseInt(((Interaction)userInteractions.get(i)).getValue());
                                try {
                                    predict = r.predict(((Interaction)userInteractions.get(i)).getUserId(), ((Interaction)userInteractions.get(i)).getItemId(), this.context);
                                }
                                catch (Exception e) {
                                    this.logger.log(1, e.getMessage());
                                }
                                for (Metric m : this.metrics.get(r.getId())) {
                                    if (!(m instanceof RatingMetric) || predict.isNaN()) continue;
                                    ((RatingMetric)m).addRating(n.intValue(), predict);
                                }
                            }
                            if (!allItems) continue;
                            ArrayList previous = new ArrayList();
                            ArrayList<String> arrayList = new ArrayList<String>();
                            for (int j = 0; j < userInteractions.size(); ++j) {
                                if (i > j) {
                                    previous.add(((Interaction)userInteractions.get(j)).getItemId());
                                    continue;
                                }
                                arrayList.add(((Interaction)userInteractions.get(j)).getItemId());
                            }
                            for (Context c : this.context.getAll()) {
                                if (!(c instanceof UserContext)) continue;
                                ((UserContext)c).processContext(this.getId() + ":" + this.getDataSourceId(), u.getId(), previous, Helper.Keys.Context.LastConsumed);
                                if (arrayList.size() <= 0) continue;
                                try {
                                    ((UserContext)c).processContext(this.getId() + ":" + this.getDataSourceId(), u.getId(), test.getItem((String)arrayList.get(0)), Helper.Keys.Context.Item);
                                }
                                catch (BaseException e) {
                                    e.printStackTrace();
                                    this.logger.log(1, e.getMessage());
                                }
                            }
                            try {
                                ArrayList<String> result1 = new ArrayList<String>();
                                RecommendationResult rr = r.recommend(u.getId(), this.context);
                                for (RecommendedItem item : rr.getItems()) {
                                    result1.add(item.getItemId());
                                }
                                List<String> relevant = Helper.applySubList(arrayList, this.maxRelevantItemCount);
                                if (relevant.size() <= 0) continue;
                                for (Metric m : this.metrics.get(r.getId())) {
                                    if (!(m instanceof ListMetric)) continue;
                                    ((ListMetric)m).addList(relevant, result1);
                                }
                                continue;
                            }
                            catch (Exception e) {
                                this.logger.log(1, e.getMessage());
                                e.printStackTrace();
                            }
                        }
                    }
                    if (!allItems) {
                        try {
                            ArrayList<String> interactions = new ArrayList<String>();
                            for (Interaction interaction : userInteractions) {
                                interactions.add(interaction.getItemId());
                            }
                            ArrayList<String> result1 = new ArrayList<String>();
                            RecommendationResult recommendationResult = r.recommend(u.getId(), this.context);
                            for (RecommendedItem item : recommendationResult.getItems()) {
                                result1.add(item.getItemId());
                            }
                            List<String> relevant = Helper.applySubList(interactions, this.maxRelevantItemCount);
                            if (relevant.size() > 0) {
                                for (Metric m : this.metrics.get(r.getId())) {
                                    if (!(m instanceof ListMetric)) continue;
                                    ((ListMetric)m).addList(relevant, result1);
                                }
                            }
                        }
                        catch (Exception e) {
                            this.logger.log(1, e.getMessage());
                        }
                    }
                    this.addPercentage(percentagePerUser);
                });
            }
            catch (BaseException e) {
                e.printStackTrace();
                this.setInfo(e.getMessage());
            }
            for (String key : this.metrics.keySet()) {
                Metric[] ms = this.metrics.get(key);
                HashMap<String, Double> res = new HashMap<String, Double>();
                for (Metric m : ms) {
                    res.put(m.getId(), m.getResult());
                }
                this.result.put(key, res);
            }
        }
    }

    private void trainRecommenders(DataSet train) {
        Parallel.For(Arrays.asList(this.recommenders), r -> {
            block2: {
                try {
                    r.setDataSourceId(this.getId() + ":" + this.getDataSourceId());
                    r.setDataSet(train);
                    r.train();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.logger == null) break block2;
                    this.logger.log(1, String.format("The training of recommender %s failed. Exception message: %s", r.getId(), e.getMessage()));
                    this.setInfo(String.format("The training of recommender %s failed. Exception message: %s", r.getId(), e.getMessage()));
                }
            }
        });
    }
}

