/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.experiments.metrics;

import com.recalot.common.builder.Initiator;
import com.recalot.common.builder.MetricBuilder;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import com.recalot.common.exceptions.BaseException;
import com.recalot.model.experiments.metrics.list.Coverage;
import com.recalot.model.experiments.metrics.list.FScore;
import com.recalot.model.experiments.metrics.list.Gini;
import com.recalot.model.experiments.metrics.list.MRR;
import com.recalot.model.experiments.metrics.list.Precision;
import com.recalot.model.experiments.metrics.list.Recall;
import com.recalot.model.experiments.metrics.rating.MAE;
import com.recalot.model.experiments.metrics.rating.MSE;
import com.recalot.model.experiments.metrics.rating.RMSE;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator,
Initiator {
    private List<MetricBuilder> metrics;

    public void start(BundleContext context) {
        this.metrics = new ArrayList<MetricBuilder>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fscore", FScore.class.getName());
        map.put("precision", Precision.class.getName());
        map.put("recall", Recall.class.getName());
        map.put("mrr", MRR.class.getName());
        map.put("gini", Gini.class.getName());
        map.put("coverage", Coverage.class.getName());
        map.put("mae", MAE.class.getName());
        map.put("mse", MSE.class.getName());
        map.put("rmse", RMSE.class.getName());
        for (String key : map.keySet()) {
            try {
                ConfigurationItem[] items;
                MetricBuilder builder = new MetricBuilder((Initiator)this, (String)map.get(key), key, "");
                for (ConfigurationItem item : items = Activator.getConfigurationItems((String)map.get(key))) {
                    builder.setConfiguration(item);
                }
                this.metrics.add(builder);
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
        for (MetricBuilder c : this.metrics) {
            context.registerService(MetricBuilder.class.getName(), (Object)c, null);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.metrics != null) {
            this.metrics = null;
        }
    }

    public Object createInstance(String className) {
        try {
            Class<?> c = Class.forName(className);
            return c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ConfigurationItem[] getConfigurationItems(String className) {
        HashMap<String, ConfigurationItem> items = new HashMap<String, ConfigurationItem>();
        try {
            for (Class<?> recommender = Class.forName(className); recommender != null; recommender = recommender.getSuperclass()) {
                Configuration[] annotations;
                Configuration config;
                if (recommender.isAnnotationPresent(Configuration.class) && (config = recommender.getAnnotation(Configuration.class)) != null && !items.containsKey(config.key())) {
                    items.put(config.key(), new ConfigurationItem(config.key(), config.type(), config.value(), config.requirement(), config.description(), new ArrayList<String>(Arrays.asList(config.options()))));
                }
                if (!recommender.isAnnotationPresent(Configurations.class)) continue;
                for (Configuration t : annotations = recommender.getAnnotation(Configurations.class).value()) {
                    if (items.containsKey(t.key())) continue;
                    items.put(t.key(), new ConfigurationItem(t.key(), t.type(), t.value(), t.requirement(), t.description(), new ArrayList<String>(Arrays.asList(t.options()))));
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
        return items.values().toArray(new ConfigurationItem[items.size()]);
    }
}

