/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.data.connections.downloader.ciao;

import com.recalot.common.Helper;
import com.recalot.common.communication.InnerIds;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.Relation;
import com.recalot.common.communication.User;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.exceptions.NotFoundException;
import com.recalot.model.data.connections.downloader.BaseDownloaderDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;

public class CiaoDataSource
extends BaseDownloaderDataSource {
    public static String Genre = "genre".intern();

    public void connect() throws BaseException {
        String source = "ciao";
        File folder = null;
        try {
            folder = this.downloadData(source, "http://librec.net/datasets/CiaoDVD.zip");
            File trustFile = null;
            File ratingsFile = null;
            String dirPath = "";
            for (File file : folder.listFiles()) {
                String name = file.getName().toLowerCase();
                if (name.toLowerCase().equals("movie-ratings.txt")) {
                    ratingsFile = file;
                    continue;
                }
                if (!name.toLowerCase().equals("trusts.txt")) continue;
                trustFile = file;
            }
            if (trustFile == null || ratingsFile == null) {
                throw new NotFoundException("Can not find necessary files in '%s'.", dirPath);
            }
            this.setInfo("Read Interactions");
            this.readRatingsFile(ratingsFile);
            this.setInfo("Read Trust");
            this.readTrustFile(trustFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setInfo("Done");
    }

    private void readRatingsFile(File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            int i = 0;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(",");
                if (split.length != 6) continue;
                String ratingId = "" + i++;
                String userId = split[0];
                String itemId = split[1];
                String genreId = split[2];
                String rating = split[4];
                String date = split[5];
                if (!this.users.containsKey(InnerIds.getNextId((String)userId))) {
                    this.users.put(InnerIds.getNextId((String)userId), new User(userId));
                }
                if (!this.items.containsKey(InnerIds.getNextId((String)itemId))) {
                    HashMap<String, String> content = new HashMap<String, String>();
                    content.put(Genre, genreId);
                    this.items.put(InnerIds.getNextId((String)itemId), new Item(itemId, content));
                }
                this.interactions.put(InnerIds.getNextId((String)ratingId), new Interaction(ratingId, userId, itemId, format.parse(date), "rating".intern(), rating.intern(), null));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void readTrustFile(File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            int i = 0;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(",");
                if (split.length != 3) continue;
                String trustor = split[0];
                String trustee = split[1];
                String trustValue = split[2];
                HashMap<String, String> content = new HashMap<String, String>();
                content.put(Helper.Keys.Value, trustValue);
                String id = "" + i++;
                this.relations.put(InnerIds.getNextId((String)id), new Relation(id, trustor, trustee, "trust".intern(), content));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }
}

