/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.data.connections.downloader.movielens;

import com.recalot.common.communication.DataSet;
import com.recalot.common.communication.InnerIds;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.User;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.exceptions.NotFoundException;
import com.recalot.model.data.connections.downloader.BaseDownloaderDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

@Configuration(key="source", type=ConfigurationItem.ConfigurationItemType.Options, options={"ml-100k", "ml-1m", "ml-10m", "ml-20m", "ml-latest-small", "ml-latest"})
public class MovieLensDataSource
extends BaseDownloaderDataSource {
    private final String Gender = "Gender".intern();
    private final String Age = "Age".intern();
    private final String Occupation = "Occupation".intern();
    private final String ZipCode = "ZipCode".intern();
    private final String Title = "Title".intern();
    private final String Year = "Year".intern();
    private final String Genres = "Genres".intern();
    private final String Rating = "Rating".intern();
    private String source;
    private DataSet dataSet;

    public void setSource(String source) {
        this.source = source;
    }

    public void connect() throws BaseException {
        try {
            if (this.source != null && !this.source.isEmpty()) {
                switch (this.source) {
                    case "ml-1m": {
                        this.initialize1m();
                        break;
                    }
                    case "ml-10m": {
                        this.initialize10m();
                        break;
                    }
                    case "ml-100k": {
                        this.initialize100k();
                        break;
                    }
                    default: {
                        this.initializeSource();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setInfo("Done");
    }

    private void initialize100k() throws IOException, NotFoundException {
        File folder = this.downloadData(this.source, "http://files.grouplens.org/datasets/movielens/ml-100k.zip");
        String folderName = "ml-100k";
        File moviesFile = null;
        File ratingsFile = null;
        File usersFile = null;
        String dirPath = "";
        for (File dir : folder.listFiles()) {
            if (!dir.getName().toLowerCase().equals(folderName)) continue;
            dirPath = dir.getAbsolutePath();
            for (File file : dir.listFiles()) {
                String name = file.getName().toLowerCase();
                if (name.toLowerCase().equals("u.data")) {
                    ratingsFile = file;
                    continue;
                }
                if (name.toLowerCase().equals("u.item")) {
                    moviesFile = file;
                    continue;
                }
                if (!name.toLowerCase().equals("u.user")) continue;
                usersFile = file;
            }
        }
        if (moviesFile == null || ratingsFile == null || usersFile == null) {
            throw new NotFoundException("Can not find necessary files in '%s'.", dirPath);
        }
        this.setInfo("Read Users");
        this.readSmallUsersFile(usersFile);
        this.setInfo("Read Items");
        this.readSmallMoviesFile(moviesFile);
        this.setInfo("Read Interactions");
        this.readSmallRatingsFile(ratingsFile);
    }

    private void initialize1m() throws IOException, NotFoundException {
        File folder = this.downloadData(this.source, "http://files.grouplens.org/datasets/movielens/ml-1m.zip");
        String folderName = "ml-1m";
        File moviesFile = null;
        File ratingsFile = null;
        File usersFile = null;
        String dirPath = "";
        for (File dir : folder.listFiles()) {
            if (!dir.getName().toLowerCase().equals(folderName)) continue;
            dirPath = dir.getAbsolutePath();
            for (File file : dir.listFiles()) {
                String name = file.getName().toLowerCase();
                if (name.equals("users.dat")) {
                    usersFile = file;
                    continue;
                }
                if (name.equals("ratings.dat")) {
                    ratingsFile = file;
                    continue;
                }
                if (!name.toLowerCase().equals("movies.dat")) continue;
                moviesFile = file;
            }
        }
        if (moviesFile == null || ratingsFile == null || usersFile == null) {
            throw new NotFoundException("Can not find necessary files in '%s'.", dirPath);
        }
        this.setInfo("Read Users");
        this.readUsers(usersFile);
        this.setInfo("Read Items");
        this.readMovies(moviesFile, "::", false);
        this.setInfo("Read Interactions");
        this.readRatings(ratingsFile, "::", false);
    }

    private void initialize10m() throws IOException, NotFoundException {
        File folder = this.downloadData(this.source, "http://files.grouplens.org/datasets/movielens/ml-10m.zip");
        String folderName = "ml-10M100K";
        File moviesFile = null;
        File ratingsFile = null;
        String dirPath = "";
        for (File dir : folder.listFiles()) {
            if (!dir.getName().equals(folderName)) continue;
            dirPath = dir.getAbsolutePath();
            for (File file : dir.listFiles()) {
                String name = file.getName().toLowerCase();
                if (name.equals("ratings.dat")) {
                    ratingsFile = file;
                    continue;
                }
                if (!name.toLowerCase().equals("movies.dat")) continue;
                moviesFile = file;
            }
        }
        if (moviesFile == null || ratingsFile == null) {
            throw new NotFoundException("Can not find necessary files in '%s'.", dirPath);
        }
        this.setInfo("Read Items");
        this.readMovies(moviesFile, "::", false);
        this.setInfo("Read Interactions");
        this.readRatings(ratingsFile, "::", false);
    }

    private void initializeSource() throws IOException, NotFoundException {
        File folder = this.downloadData(this.source, "http://files.grouplens.org/datasets/movielens/ml-20m.zip");
        File moviesFile = null;
        File ratingsFile = null;
        Object usersFile = null;
        String dirPath = "";
        for (File dir : folder.listFiles()) {
            if (!dir.getName().toLowerCase().equals(this.source)) continue;
            dirPath = dir.getAbsolutePath();
            for (File file : dir.listFiles()) {
                String name = file.getName().toLowerCase();
                if (name.equals("ratings.csv")) {
                    ratingsFile = file;
                    continue;
                }
                if (!name.toLowerCase().equals("movies.csv")) continue;
                moviesFile = file;
            }
        }
        if (moviesFile == null || ratingsFile == null) {
            throw new NotFoundException("Can not find necessary files in '%s'.", dirPath);
        }
        this.setInfo("Read Items");
        this.readMovies(moviesFile, ",", true);
        this.setInfo("Read Interactions");
        this.readRatings(ratingsFile, ",", true);
    }

    private void readSmallRatingsFile(File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line = null;
            boolean i = false;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("\t");
                if (split.length != 4) continue;
                String ratingId = split[0] + split[1] + split[2];
                String userId = split[0];
                String itemId = split[1];
                Date date = new Date(Long.parseLong(split[3]));
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(this.Rating, split[2].intern());
                if (!this.users.containsKey(InnerIds.getNextId((String)userId))) {
                    this.users.put(InnerIds.getNextId((String)userId), new User(userId));
                }
                this.interactions.put(InnerIds.getNextId((String)ratingId), new Interaction(ratingId, userId, itemId, date, "rating".intern(), split[2].intern(), map));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    private void readSmallMoviesFile(File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line = null;
            ArrayList<String> cats = new ArrayList<String>();
            cats.add("unknown");
            cats.add("Action");
            cats.add("Adventure");
            cats.add("Animation");
            cats.add("Children's");
            cats.add("Comedy");
            cats.add("Crime");
            cats.add("Documentary");
            cats.add("Drama");
            cats.add("Fantasy");
            cats.add("Film-Noir");
            cats.add("Horror");
            cats.add("Musical");
            cats.add("Mystery");
            cats.add("Romance");
            cats.add("Sci-Fi");
            cats.add("Thriller");
            cats.add("War");
            cats.add("Western");
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("\\|");
                if (split.length != 24) continue;
                String itemId = split[0];
                HashMap<String, String> map = new HashMap<String, String>();
                String title = split[1];
                String year = "";
                if (title.contains("(")) {
                    year = title.substring(title.lastIndexOf("(") + 1, title.lastIndexOf(")")).intern();
                }
                map.put(this.Title, title);
                map.put(this.Year, year);
                String categories = "";
                for (int i = 0; i < 19; ++i) {
                    if (!split[5 + i].equals("1")) continue;
                    if (categories.length() > 0) {
                        categories = categories + "|";
                    }
                    categories = categories + (String)cats.get(i);
                }
                map.put(this.Genres, categories);
                this.items.put(InnerIds.getNextId((String)itemId), new Item(itemId, map));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    private void readSmallUsersFile(File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("\\|");
                if (split.length != 5) continue;
                String userId = split[0];
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(this.Gender, split[2]);
                map.put(this.Age, split[1]);
                map.put(this.Occupation, split[3]);
                map.put(this.ZipCode, split[4]);
                this.users.put(InnerIds.getNextId((String)userId), new User(userId, map));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    private void readUsers(File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("::");
                if (split.length != 5) continue;
                String userId = split[0];
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(this.Gender, split[1]);
                map.put(this.Age, split[2]);
                map.put(this.Occupation, split[3]);
                map.put(this.ZipCode, split[4]);
                this.users.put(InnerIds.getNextId((String)userId), new User(userId, map));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    private void readRatings(File file, String sep, boolean hasHeader) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line = null;
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                if (hasHeader && first) {
                    first = false;
                    continue;
                }
                String[] split = line.split(sep);
                if (split.length != 4) continue;
                String ratingId = split[0] + split[1] + split[2];
                String userId = split[0];
                String itemId = split[1];
                Date date = new Date(Long.parseLong(split[3]));
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(this.Rating, split[2]);
                if (!this.users.containsKey(InnerIds.getNextId((String)userId))) {
                    this.users.put(InnerIds.getNextId((String)userId), new User(userId));
                }
                this.interactions.put(InnerIds.getNextId((String)ratingId), new Interaction(ratingId, userId, itemId, date, "rating".intern(), split[2].intern(), map));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    private void readMovies(File file, String sep, boolean hasHeader) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line = null;
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                if (hasHeader && first) {
                    first = false;
                    continue;
                }
                String[] split = line.split(sep);
                if (split.length != 3) continue;
                String itemId = split[0];
                HashMap<String, String> map = new HashMap<String, String>();
                String title = split[1];
                if (title.contains("(") && title.contains(")")) {
                    String year = title.substring(title.lastIndexOf("(") + 1, title.lastIndexOf(")")).intern();
                    map.put(this.Year, year);
                }
                map.put(this.Title, title);
                map.put(this.Genres, split[2]);
                this.items.put(InnerIds.getNextId((String)itemId), new Item(itemId, map));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
    }
}

