/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.data.connections.mysql;

import com.recalot.common.Helper;
import com.recalot.common.communication.DataSet;
import com.recalot.common.communication.DataSourceDataSet;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.Message;
import com.recalot.common.communication.Relation;
import com.recalot.common.communication.User;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.Configurations;
import com.recalot.common.exceptions.AlreadyExistsException;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.exceptions.NotFoundException;
import com.recalot.common.interfaces.model.data.DataSource;
import flexjson.JSONDeserializer;
import flexjson.JSONSerializer;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Configurations(value={@Configuration(key="sqlServer"), @Configuration(key="sqlUsername"), @Configuration(key="sqlPassword"), @Configuration(key="sqlDatabase")})
public class MySQLDataSource
extends DataSource {
    private boolean initialized = false;
    private DataSet dataSet;
    private String sqlServer;
    private String sqlUsername;
    private String sqlPassword;
    private String sqlDatabase;
    private String connectionPlaceHolder = "jdbc:%s/%s?autoReconnect=true&useUnicode=true&characterEncoding=UTF-8";
    private Connection connection;
    public ConcurrentHashMap<String, User> users;
    public ConcurrentHashMap<String, Item> items;
    public ConcurrentHashMap<String, Interaction> interactions;
    public ConcurrentHashMap<String, Relation> relations;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.lock.writeLock();
    private IdComputation idComputation;

    public MySQLDataSource() {
        this.users = new ConcurrentHashMap();
        this.items = new ConcurrentHashMap();
        this.interactions = new ConcurrentHashMap();
        this.relations = new ConcurrentHashMap();
    }

    public String getSqlServer() {
        return this.sqlServer;
    }

    public void setSqlServer(String sqlServer) {
        this.sqlServer = sqlServer;
    }

    public String getSqlUsername() {
        return this.sqlUsername;
    }

    public void setSqlUsername(String sqlUsername) {
        this.sqlUsername = sqlUsername;
    }

    public String getSqlPassword() {
        return this.sqlPassword;
    }

    public void setSqlPassword(String sqlPassword) {
        this.sqlPassword = sqlPassword;
    }

    public String getSqlDatabase() {
        return this.sqlDatabase;
    }

    public void setSqlDatabase(String sqlDatabase) {
        this.sqlDatabase = sqlDatabase;
    }

    public Connection getNewConnection() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            return DriverManager.getConnection(String.format(this.connectionPlaceHolder, this.sqlServer, this.sqlDatabase), this.sqlUsername, this.sqlPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void connect() throws BaseException {
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            this.connection = DriverManager.getConnection(String.format(this.connectionPlaceHolder, this.sqlServer, this.sqlDatabase), this.sqlUsername, this.sqlPassword);
            this.dataSet = new DataSourceDataSet((DataSource)this);
            if (!this.structureAvailable()) {
                this.setInfo("Create DB structure");
                this.createDBstructure();
            }
            this.setInfo("Read ID table");
            this.readIdComputation();
            this.setInfo("Read Users");
            this.readUsers();
            this.setInfo("Read Items");
            this.readItems();
            this.setInfo("Read Interactions");
            this.readInteractions();
            this.setInfo("Read Relations");
            this.readRelations();
            this.setInfo("Done");
            this.initialized = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NotFoundException("SQL Server not found");
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIdComputation() {
        ResultSet result = null;
        Statement statement = null;
        this.idComputation = new IdComputation();
        try {
            statement = this.connection.prepareStatement("SELECT * FROM " + this.sqlDatabase + ".idcomputation");
            result = statement.executeQuery();
            while (result.next()) {
                try {
                    String type = result.getString(1);
                    String next = result.getString(2);
                    int parsed = Integer.parseInt(next);
                    if (parsed <= 0) continue;
                    this.idComputation.setNextID(type, parsed);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean structureAvailable() throws SQLException {
        try (ResultSet result = null;){
            DatabaseMetaData md = this.connection.getMetaData();
            result = md.getTables(null, null, "%", null);
            ArrayList<String> existingTables = new ArrayList<String>();
            while (result.next()) {
                existingTables.add(result.getString(3).toLowerCase());
            }
            ArrayList<String> necessaryTables = new ArrayList<String>();
            necessaryTables.add("users");
            necessaryTables.add("items");
            necessaryTables.add("interactions");
            necessaryTables.add("relations");
            necessaryTables.add("idcomputation");
            for (String t : necessaryTables) {
                if (existingTables.contains(t)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public void createDBstructure() throws SQLException {
        Statement statement = null;
        ResultSet result = null;
        try {
            DatabaseMetaData md = this.connection.getMetaData();
            result = md.getTables(null, null, "%", null);
            ArrayList<String> existingTables = new ArrayList<String>();
            while (result.next()) {
                existingTables.add(result.getString(3).toLowerCase());
            }
            statement = this.connection.createStatement();
            if (!existingTables.contains("users")) {
                statement.execute("CREATE TABLE users (id VARCHAR(128) NOT NULL PRIMARY KEY,content TEXT NOT NULL)");
            }
            if (!existingTables.contains("items")) {
                statement.execute("CREATE TABLE items (id VARCHAR(128) NOT NULL PRIMARY KEY,content TEXT NOT NULL)");
            }
            if (!existingTables.contains("interactions")) {
                statement.execute("CREATE TABLE interactions (id VARCHAR(128) NOT NULL PRIMARY KEY,userId VARCHAR(128) NOT NULL,itemId VARCHAR(128) NOT NULL,timeStamp TIMESTAMP NOT NULL,type VARCHAR(128) NOT NULL,value VARCHAR(128) NOT NULL,content TEXT NOT NULL)");
            }
            if (!existingTables.contains("relations")) {
                statement.execute("CREATE TABLE relations (id VARCHAR(128) NOT NULL PRIMARY KEY,fromId VARCHAR(128) NOT NULL,toId VARCHAR(128) NOT NULL,type VARCHAR(128) NOT NULL,content TEXT NOT NULL)");
            }
            if (!existingTables.contains("idcomputation")) {
                statement.execute("CREATE TABLE idcomputation (id VARCHAR(128) NOT NULL PRIMARY KEY,next INT  NOT NULL)");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (result != null) {
                result.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readInteractions() {
        ResultSet result = null;
        Statement statement = null;
        try {
            statement = this.connection.prepareStatement("SELECT * FROM " + this.sqlDatabase + ".interactions");
            result = statement.executeQuery();
            while (result.next()) {
                try {
                    Date timeStamp;
                    String id = result.getString(1);
                    String userId = result.getString(2);
                    String itemId = result.getString(3);
                    try {
                        timeStamp = new Date(result.getTimestamp(4).getTime());
                    }
                    catch (Exception e) {
                        timeStamp = new Date(0L);
                    }
                    String type = result.getString(5);
                    String value = result.getString(6);
                    HashMap map = (HashMap)new JSONDeserializer().deserialize(result.getString(7));
                    this.interactions.put(id, new Interaction(id, userId, itemId, timeStamp, type, value, (Map)map));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRelations() {
        ResultSet result = null;
        Statement statement = null;
        try {
            statement = this.connection.prepareStatement("SELECT * FROM " + this.sqlDatabase + ".relations");
            result = statement.executeQuery();
            while (result.next()) {
                try {
                    String id = result.getString(1);
                    String fromId = result.getString(2);
                    String toId = result.getString(3);
                    String type = result.getString(4);
                    HashMap map = (HashMap)new JSONDeserializer().deserialize(result.getString(5));
                    this.relations.put(id, new Relation(id, fromId, toId, type, (Map)map));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readItems() {
        ResultSet result = null;
        Statement statement = null;
        try {
            statement = this.connection.prepareStatement("SELECT * FROM " + this.sqlDatabase + ".items");
            result = statement.executeQuery();
            while (result.next()) {
                try {
                    String id = result.getString(1);
                    String content = result.getString(2);
                    HashMap map = (HashMap)new JSONDeserializer().deserialize(content);
                    this.items.put(id, new Item(id, (Map)map));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readUsers() {
        ResultSet result = null;
        Statement statement = null;
        try {
            statement = this.connection.prepareStatement("SELECT * FROM " + this.sqlDatabase + ".users");
            result = statement.executeQuery();
            while (result.next()) {
                try {
                    String id = result.getString(1);
                    String content = result.getString(2);
                    HashMap map = (HashMap)new JSONDeserializer().deserialize(content);
                    this.users.put(id, new User(id, (Map)map));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void close() throws IOException {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public int getRelationCount() {
        return this.relations.size();
    }

    public Relation[] getRelations() throws BaseException {
        return this.relations.values().toArray(new Relation[this.relations.size()]);
    }

    public Relation getRelation(String relationId) throws BaseException {
        return this.relations.get(relationId);
    }

    public Relation[] getRelations(String fromId, String toId) throws BaseException {
        if (fromId != null && toId == null) {
            return (Relation[])this.relations.values().stream().filter(i -> i.getFromId().equals(fromId)).toArray(Relation[]::new);
        }
        if (fromId == null && toId != null) {
            return (Relation[])this.relations.values().stream().filter(i -> i.getToId().equals(toId)).toArray(Relation[]::new);
        }
        return (Relation[])this.relations.values().stream().filter(i -> i.getFromId().equals(fromId) && i.getToId().equals(toId)).toArray(Relation[]::new);
    }

    public Relation[] getRelationsFor(String fromId) throws BaseException {
        return (Relation[])this.relations.values().stream().filter(i -> i.getFromId().equals(fromId)).toArray(Relation[]::new);
    }

    public Relation updateRelation(String relationId, String fromId, String toId, String type, Map<String, String> content) throws BaseException {
        if (this.relations.containsKey(relationId)) {
            Relation relation = new Relation(relationId, fromId, toId, type, this.filterParams(content, Helper.Keys.FromId, Helper.Keys.ToId, Helper.Keys.Type));
            this.relations.replace(relationId, relation);
            this.updateAtSql(relation);
            return relation;
        }
        throw new NotFoundException("An relationId with the id '%s' could not be found", relationId);
    }

    public Relation createRelation(String fromId, String toId, String type, Map<String, String> content) throws BaseException {
        Relation relation = new Relation("" + this.idComputation.getNextID("relation"), fromId, toId, type, this.filterParams(content, Helper.Keys.FromId, Helper.Keys.ToId, Helper.Keys.Type));
        this.relations.put(relation.getId(), relation);
        this.putToSql(relation);
        return relation;
    }

    public Interaction[] getInteractions() throws BaseException {
        return this.interactions.values().toArray(new Interaction[this.interactions.size()]);
    }

    public int getInteractionsCount() {
        return this.interactions.size();
    }

    public Interaction[] getInteractions(String userId) throws BaseException {
        return (Interaction[])this.interactions.values().stream().filter(i -> i.getUserId().equals(userId)).toArray(Interaction[]::new);
    }

    public Interaction[] getInteractions(String itemId, String userId) throws BaseException {
        return (Interaction[])this.interactions.values().stream().filter(i -> i.getUserId().equals(userId) && i.getItemId().equals(itemId)).toArray(Interaction[]::new);
    }

    public Message addInteraction(String itemId, String userId, Date timestamp, String type, String value, Map<String, String> content) throws BaseException {
        Interaction interaction = new Interaction("" + this.idComputation.getNextID("interactions"), userId, itemId, timestamp, type, value, this.filterParams(content, Helper.Keys.TimeStamp, Helper.Keys.UserId, Helper.Keys.UserId, Helper.Keys.ItemId));
        this.interactions.put(interaction.getId(), interaction);
        this.putToSql(interaction);
        return new Message("Interaction successful saved", "Interaction successful saved", Message.Status.INFO);
    }

    public Item[] getItems() throws BaseException {
        return this.items.values().toArray(new Item[this.items.size()]);
    }

    public int getItemsCount() {
        return this.items.size();
    }

    public Item getItem(String itemId) throws BaseException {
        if (!this.items.containsKey(itemId)) {
            throw new NotFoundException("Item with id %s cannot be found.", "" + itemId);
        }
        return this.items.get(itemId);
    }

    public Item tryGetItem(String itemId) throws BaseException {
        return this.items.get(itemId);
    }

    public Item updateItem(String itemId, Map<String, String> content) throws BaseException {
        if (this.items.containsKey(itemId)) {
            Item item = new Item(itemId, this.filterParams(content, new String[0]));
            this.items.replace(itemId, item);
            this.updateAtSql(item);
            return item;
        }
        throw new NotFoundException("An item with the id '%s' could not be found", itemId);
    }

    public Item createItem(Map<String, String> content) throws BaseException {
        String wishedItemId = content.get(Helper.Keys.ItemId);
        if (wishedItemId != null && !wishedItemId.isEmpty()) {
            if (this.users.containsKey(wishedItemId)) {
                throw new AlreadyExistsException("An item with the id %s already exists.", wishedItemId);
            }
        } else {
            wishedItemId = "" + this.idComputation.getNextID("items");
        }
        Item item = new Item(wishedItemId, this.filterParams(content, new String[0]));
        this.items.put(item.getId(), item);
        this.putToSql(item);
        return item;
    }

    public Message deleteItem(String itemId) throws BaseException {
        if (this.items.containsKey(itemId)) {
            this.items.remove(itemId);
            this.removeItemFromSql(itemId);
            return new Message("Item successful removed", "Item with id='" + itemId + "' successful deleted", Message.Status.INFO);
        }
        throw new NotFoundException("Item with id %s cannot be found.", "" + itemId);
    }

    public User[] getUsers() throws BaseException {
        return this.users.values().toArray(new User[this.users.size()]);
    }

    public int getUsersCount() {
        return this.users.size();
    }

    public User getUser(String userId) throws BaseException {
        if (!this.users.containsKey(userId)) {
            throw new NotFoundException("User with id %s cannot be found.", "" + userId);
        }
        return this.users.get(userId);
    }

    public User tryGetUser(String userId) throws BaseException {
        return this.users.get(userId);
    }

    public User updateUser(String userId, Map<String, String> content) throws BaseException {
        if (this.users.containsKey(userId)) {
            User user = new User(userId, this.filterParams(content, new String[0]));
            this.users.replace(userId, user);
            this.updateAtSql(user);
            return user;
        }
        throw new NotFoundException("A user with the id '%s' could not be found", userId);
    }

    public User createUser(Map<String, String> content) throws BaseException {
        String wishedUserId = content.get(Helper.Keys.UserId);
        if (wishedUserId != null && !wishedUserId.isEmpty()) {
            if (this.users.containsKey(wishedUserId)) {
                throw new AlreadyExistsException("A user with the id %s already exists.", wishedUserId);
            }
        } else {
            wishedUserId = "" + this.idComputation.getNextID("users");
        }
        User user = new User(wishedUserId, this.filterParams(content, new String[0]));
        this.users.put(user.getId(), user);
        this.putToSql(user);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToSql(User user) {
        Statement statement = null;
        try {
            this.writeLock.lock();
            Map<String, String> contentMap = this.filterParams(user.getContent(), new String[0]);
            String content = new JSONSerializer().serialize(contentMap);
            if (this.connection == null || this.connection.isClosed() || !this.connection.isValid(2)) {
                this.connection = this.getNewConnection();
            }
            statement = this.connection.prepareStatement("INSERT IGNORE INTO users (id, content) VALUES (?, ?)");
            statement.setString(1, user.getId());
            statement.setString(2, content);
            statement.executeUpdate();
            this.putToSql(this.idComputation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                statement = null;
            }
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToSql(IdComputation idComputation) {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement("REPLACE INTO idcomputation (id, next) VALUES (?, ?)");
            for (String key : idComputation.getTypes()) {
                statement.setString(1, key);
                statement.setInt(2, idComputation.getCurrent(key));
                statement.executeUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                statement = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToSql(Item item) {
        Statement statement = null;
        try {
            this.writeLock.lock();
            Map<String, String> contentMap = this.filterParams(item.getContent(), new String[0]);
            String content = new JSONSerializer().serialize(contentMap);
            if (this.connection == null || this.connection.isClosed() || !this.connection.isValid(2)) {
                this.connection = this.getNewConnection();
            }
            statement = this.connection.prepareStatement("INSERT IGNORE INTO items (id, content) VALUES (?, ?)");
            statement.setString(1, item.getId());
            statement.setString(2, content);
            statement.executeUpdate();
            this.putToSql(this.idComputation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                statement = null;
            }
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToSql(Interaction interaction) {
        Statement statement = null;
        try {
            this.writeLock.lock();
            Map<String, String> contentMap = this.filterParams(interaction.getContent(), "type", "value");
            String content = new JSONSerializer().serialize(contentMap);
            if (this.connection == null || this.connection.isClosed() || !this.connection.isValid(2)) {
                this.connection = this.getNewConnection();
            }
            statement = this.connection.prepareStatement("INSERT IGNORE INTO interactions (id, userId, itemId, timeStamp, type, value, content) VALUES (?, ?, ?, ?, ? , ? , ?)");
            statement.setString(1, interaction.getId());
            statement.setString(2, interaction.getUserId());
            statement.setString(3, interaction.getItemId());
            statement.setTimestamp(4, new Timestamp(interaction.getTimeStamp().getTime()));
            statement.setString(5, interaction.getType());
            statement.setString(6, interaction.getValue());
            statement.setString(7, content);
            statement.executeUpdate();
            this.putToSql(this.idComputation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                statement = null;
            }
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToSql(Relation relation) {
        Statement statement = null;
        try {
            this.writeLock.lock();
            Map<String, String> contentMap = this.filterParams(relation.getContent(), "type", "value");
            String content = new JSONSerializer().serialize(contentMap);
            if (this.connection == null || this.connection.isClosed() || !this.connection.isValid(2)) {
                this.connection = this.getNewConnection();
            }
            statement = this.connection.prepareStatement("INSERT IGNORE INTO relations (id, fromId, toId, type, content) VALUES (?, ?, ?, ?, ?)");
            statement.setString(1, relation.getId());
            statement.setString(2, relation.getFromId());
            statement.setString(3, relation.getToId());
            statement.setString(4, relation.getType());
            statement.setString(5, content);
            statement.executeUpdate();
            this.putToSql(this.idComputation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                statement = null;
            }
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAtSql(Relation relation) {
        Statement statement = null;
        try {
            this.writeLock.lock();
            Map<String, String> contentMap = this.filterParams(relation.getContent(), "type", "value");
            String content = new JSONSerializer().serialize(contentMap);
            if (this.connection == null || this.connection.isClosed() || !this.connection.isValid(2)) {
                this.connection = this.getNewConnection();
            }
            statement = this.connection.prepareStatement("UPDATE relations SET fromId=?, toId=?, type=?, content=? WHERE id=?");
            statement.setString(5, relation.getId());
            statement.setString(1, relation.getFromId());
            statement.setString(2, relation.getToId());
            statement.setString(3, relation.getType());
            statement.setString(4, content);
            statement.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                statement = null;
            }
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAtSql(User user) {
        Statement statement = null;
        try {
            this.writeLock.lock();
            Map<String, String> contentMap = this.filterParams(user.getContent(), new String[0]);
            String content = new JSONSerializer().serialize(contentMap);
            if (this.connection == null || this.connection.isClosed() || !this.connection.isValid(2)) {
                this.connection = this.getNewConnection();
            }
            statement = this.connection.prepareStatement("UPDATE users SET content=? WHERE id=?");
            statement.setString(2, user.getId());
            statement.setString(1, content);
            statement.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                statement = null;
            }
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAtSql(Item item) {
        Statement statement = null;
        try {
            this.writeLock.lock();
            Map<String, String> contentMap = this.filterParams(item.getContent(), new String[0]);
            String content = new JSONSerializer().serialize(contentMap);
            if (this.connection == null || this.connection.isClosed() || !this.connection.isValid(2)) {
                this.connection = this.getNewConnection();
            }
            statement = this.connection.prepareStatement("UPDATE items SET content=? WHERE id=?");
            statement.setString(2, item.getId());
            statement.setString(1, content);
            statement.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                statement = null;
            }
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeItemFromSql(String itemId) {
        Statement statement = null;
        try {
            this.writeLock.lock();
            if (this.connection == null || this.connection.isClosed() || !this.connection.isValid(2)) {
                this.connection = this.getNewConnection();
            }
            statement = this.connection.prepareStatement("DELETE FROM items WHERE id=?");
            statement.setString(1, itemId);
            statement.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                statement = null;
            }
            this.writeLock.unlock();
        }
    }

    private Map<String, String> filterParams(Map<String, String> content, String ... ignore) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : content.keySet()) {
            boolean contains = false;
            if (key.equals(Helper.Keys.SourceId)) {
                contains = true;
            } else if (key.equals(Helper.Keys.ID)) {
                contains = true;
            } else if (key.equals(Helper.Keys.UserId)) {
                contains = true;
            } else if (key.equals(Helper.Keys.ItemId)) {
                contains = true;
            } else if (ignore != null && ignore.length > 0) {
                for (String test : ignore) {
                    if (!test.equals(key)) continue;
                    contains = true;
                    break;
                }
            }
            if (contains) continue;
            map.put(key, content.get(key));
        }
        return map;
    }

    private class IdComputation {
        private final HashMap<String, Integer> nextDict = new HashMap();

        private IdComputation() {
        }

        private int getNextID(String type) {
            int next = 1;
            if (this.nextDict.containsKey(type)) {
                next = this.nextDict.get(type);
                ++next;
            }
            this.nextDict.put(type, next);
            return next;
        }

        private void setNextID(String type, int next) {
            this.nextDict.put(type, next);
        }

        public Set<String> getTypes() {
            return this.nextDict.keySet();
        }

        public int getCurrent(String key) {
            return this.nextDict.get(key);
        }
    }
}

