/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.views.recommend;

import com.recalot.common.Helper;
import com.recalot.common.communication.TemplateResult;
import com.recalot.common.interfaces.controller.RecommenderController;
import com.recalot.common.interfaces.controller.RequestAction;
import com.recalot.views.common.GenericControllerHandler;
import com.recalot.views.common.HTTPMethods;
import com.recalot.views.common.WebService;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Servlet
extends HttpServlet {
    private GenericControllerHandler handler;

    public Servlet(GenericControllerHandler handler) {
        this.handler = handler;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processRequest(req, res, HTTPMethods.GET);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processRequest(req, res, HTTPMethods.POST);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processRequest(req, res, HTTPMethods.DELETE);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processRequest(req, res, HTTPMethods.PUT);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        WebService.processOptionsRequest((HttpServletRequest)req, (HttpServletResponse)res, (String)"GET, POST, PUT, DELETE, OPTIONS");
    }

    protected void processRequest(HttpServletRequest req, HttpServletResponse res, HTTPMethods method) throws ServletException, IOException {
        String tempKey;
        res.setHeader("Access-Control-Allow-Origin", "*");
        res.setHeader("Access-Control-Allow-Origin", "*");
        String pathInfo = req.getPathInfo();
        HashMap<String, String> params = new HashMap<String, String>();
        Map names = req.getParameterMap();
        if (names != null) {
            for (Object key : names.keySet()) {
                params.put(URLDecoder.decode((String)key, "UTF-8"), URLDecoder.decode(req.getParameter((String)key), "UTF-8"));
            }
        }
        String templateKey = "json";
        if (params.containsKey(Helper.Keys.OutputParam) && (tempKey = (String)params.get(Helper.Keys.OutputParam)) != null && !tempKey.equals("")) {
            templateKey = tempKey;
        }
        TemplateResult result = null;
        try {
            String[] split;
            if (pathInfo != null && !pathInfo.equals("") && (split = (pathInfo = pathInfo.substring(1)).split("/")).length == 1) {
                params.put(Helper.Keys.RecommenderId, split[0]);
                result = this.handler.process((RequestAction)RecommenderController.RecommenderRequestAction.Recommend, templateKey, params);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result != null) {
            res.setContentType(result.getContentType());
            res.setCharacterEncoding(result.getCharset().name());
            res.setStatus(result.getStatus());
            PrintWriter out = res.getWriter();
            Helper.copy((PrintWriter)out, (InputStream)result.getResult());
        }
    }
}

