/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.views.data.access;

import com.recalot.common.Helper;
import com.recalot.common.communication.TemplateResult;
import com.recalot.common.interfaces.controller.DataAccessController;
import com.recalot.common.interfaces.controller.RequestAction;
import com.recalot.views.common.GenericControllerHandler;
import com.recalot.views.common.HTTPMethods;
import com.recalot.views.common.WebService;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Servlet
extends HttpServlet {
    private GenericControllerHandler handler;

    public Servlet(GenericControllerHandler handler) {
        this.handler = handler;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processRequest(req, res, HTTPMethods.GET);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processRequest(req, res, HTTPMethods.POST);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processRequest(req, res, HTTPMethods.PUT);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processRequest(req, res, HTTPMethods.DELETE);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        WebService.processOptionsRequest((HttpServletRequest)req, (HttpServletResponse)res, (String)"GET, POST, PUT, DELETE, OPTIONS");
    }

    protected void processRequest(HttpServletRequest req, HttpServletResponse res, HTTPMethods method) throws ServletException, IOException {
        String tempKey;
        res.setHeader("Access-Control-Allow-Origin", "*");
        HashMap<String, String> params = new HashMap<String, String>();
        Map names = req.getParameterMap();
        if (names != null) {
            for (Object key : names.keySet()) {
                params.put(URLDecoder.decode((String)key, "UTF-8"), URLDecoder.decode(req.getParameter((String)key), "UTF-8"));
            }
        }
        String templateKey = "json";
        if (params.containsKey(Helper.Keys.OutputParam) && (tempKey = (String)params.get(Helper.Keys.OutputParam)) != null && !tempKey.equals("")) {
            templateKey = tempKey;
        }
        String pathInfo = req.getPathInfo();
        TemplateResult result = null;
        if (pathInfo != null && !pathInfo.equals("")) {
            pathInfo = pathInfo.substring(1);
            String[] split = pathInfo.split("/");
            switch (split.length) {
                case 2: {
                    if (!split[0].toLowerCase().equals("sources")) break;
                    params.put(Helper.Keys.SourceId, split[1]);
                    switch (method) {
                        case GET: {
                            result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.GetData, templateKey, params);
                        }
                    }
                    break;
                }
                case 3: {
                    if (!split[0].toLowerCase().equals("sources")) break;
                    params.put(Helper.Keys.SourceId, split[1]);
                    if (split[2].toLowerCase().equals("users")) {
                        switch (method) {
                            case PUT: {
                                result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.CreateUser, templateKey, params);
                                break;
                            }
                            case GET: {
                                result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.GetUsers, templateKey, params);
                            }
                        }
                        break;
                    }
                    if (split[2].toLowerCase().equals("items")) {
                        switch (method) {
                            case PUT: {
                                result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.CreateItem, templateKey, params);
                                break;
                            }
                            case GET: {
                                result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.GetItems, templateKey, params);
                                break;
                            }
                            case DELETE: {
                                result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.DeleteItem, templateKey, params);
                            }
                        }
                        break;
                    }
                    if (split[2].toLowerCase().equals("interactions")) {
                        switch (method) {
                            case GET: {
                                result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.GetInteractions, templateKey, params);
                            }
                        }
                        break;
                    }
                    if (!split[2].toLowerCase().equals("relations")) break;
                    switch (method) {
                        case GET: {
                            result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.GetRelations, templateKey, params);
                            break;
                        }
                        case PUT: {
                            result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.CreateRelation, templateKey, params);
                        }
                    }
                    break;
                }
                case 4: {
                    if (!split[0].toLowerCase().equals("sources")) break;
                    params.put(Helper.Keys.SourceId, split[1]);
                    if (split[2].toLowerCase().equals("users")) {
                        params.put(Helper.Keys.UserId, split[3]);
                        switch (method) {
                            case PUT: {
                                result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.UpdateUser, templateKey, params);
                                break;
                            }
                            case GET: {
                                result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.GetUser, templateKey, params);
                            }
                        }
                        break;
                    }
                    if (split[2].toLowerCase().equals("items")) {
                        params.put(Helper.Keys.ItemId, split[3]);
                        switch (method) {
                            case PUT: {
                                result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.UpdateItem, templateKey, params);
                                break;
                            }
                            case GET: {
                                result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.GetItem, templateKey, params);
                            }
                        }
                        break;
                    }
                    if (!split[2].toLowerCase().equals("relations")) break;
                    params.put(Helper.Keys.RelationId, split[3]);
                    switch (method) {
                        case PUT: {
                            result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.UpdateRelation, templateKey, params);
                            break;
                        }
                        case GET: {
                            result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.GetRelation, templateKey, params);
                        }
                    }
                    break;
                }
                case 5: {
                    if (split[0].toLowerCase().equals("sources") && split[2].toLowerCase().equals("users") && split[4].toLowerCase().equals("interactions")) {
                        params.put(Helper.Keys.SourceId, split[1]);
                        params.put(Helper.Keys.UserId, split[3]);
                        switch (method) {
                            case GET: {
                                result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.GetInteractions, templateKey, params);
                            }
                        }
                        break;
                    }
                    if (split[0].toLowerCase().equals("sources") && split[2].toLowerCase().equals("users") && split[4].toLowerCase().equals("relations")) {
                        params.put(Helper.Keys.SourceId, split[1]);
                        params.put(Helper.Keys.FromId, split[3]);
                        switch (method) {
                            case GET: {
                                result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.GetRelations, templateKey, params);
                            }
                        }
                        break;
                    }
                    if (!split[0].toLowerCase().equals("sources") || !split[2].toLowerCase().equals("items") || !split[4].toLowerCase().equals("interactions")) break;
                    params.put(Helper.Keys.SourceId, split[1]);
                    params.put(Helper.Keys.ItemId, split[3]);
                    switch (method) {
                        case GET: {
                            result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.GetInteractions, templateKey, params);
                        }
                    }
                    break;
                }
                case 6: {
                    if (!split[0].toLowerCase().equals("sources") || !split[2].toLowerCase().equals("users") || !split[4].toLowerCase().equals("relations")) break;
                    params.put(Helper.Keys.SourceId, split[1]);
                    params.put(Helper.Keys.FromId, split[3]);
                    params.put(Helper.Keys.ToId, split[5]);
                    switch (method) {
                        case GET: {
                            result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.GetRelations, templateKey, params);
                        }
                    }
                    break;
                }
                case 7: {
                    if (!split[0].toLowerCase().equals("sources") || !split[2].toLowerCase().equals("users") || !split[4].toLowerCase().equals("items") || !split[6].toLowerCase().equals("interactions")) break;
                    params.put(Helper.Keys.SourceId, split[1]);
                    params.put(Helper.Keys.UserId, split[3]);
                    params.put(Helper.Keys.ItemId, split[5]);
                    switch (method) {
                        case GET: {
                            result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.GetInteraction, templateKey, params);
                        }
                    }
                }
            }
        }
        if (result != null) {
            res.setContentType(result.getContentType());
            res.setCharacterEncoding(result.getCharset().name());
            res.setStatus(result.getStatus());
            PrintWriter out = res.getWriter();
            Helper.copy((PrintWriter)out, (InputStream)result.getResult());
        }
    }
}

