/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.data.access;

import com.recalot.common.GenericServiceListener;
import com.recalot.common.Helper;
import com.recalot.common.builder.DataSourceBuilder;
import com.recalot.common.communication.Message;
import com.recalot.common.exceptions.AlreadyExistsException;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.exceptions.MissingArgumentException;
import com.recalot.common.exceptions.NotFoundException;
import com.recalot.common.interfaces.model.data.DataInformation;
import com.recalot.common.interfaces.model.data.DataSource;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;

public class DataAccess
implements com.recalot.common.interfaces.model.data.DataAccess,
Closeable {
    private final BundleContext context;
    private final GenericServiceListener<DataSourceBuilder> dataSourceBuilderListener;
    private final ConcurrentHashMap<String, DataSource> dataSources;
    private final ConcurrentHashMap<String, Thread> threads;

    public DataAccess(BundleContext context) {
        this.context = context;
        this.dataSourceBuilderListener = new GenericServiceListener(context, DataSourceBuilder.class.getName());
        this.dataSources = new ConcurrentHashMap();
        this.threads = new ConcurrentHashMap();
        this.context.addServiceListener(this.dataSourceBuilderListener);
    }

    @Override
    public void close() throws IOException {
        if (this.threads != null) {
            this.threads.values().forEach(Thread::interrupt);
        }
        if (this.dataSourceBuilderListener != null) {
            this.context.removeServiceListener(this.dataSourceBuilderListener);
        }
        if (this.dataSources != null) {
            for (DataSource s : this.dataSources.values()) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getDataSource(String id) throws BaseException {
        ConcurrentHashMap<String, DataSource> concurrentHashMap = this.dataSources;
        synchronized (concurrentHashMap) {
            if (this.dataSources.containsKey(id)) {
                return this.dataSources.get(id);
            }
        }
        throw new NotFoundException(String.format("Data source with id %s not found.", id));
    }

    public DataSourceBuilder getDataSourceBuilder(String id) throws BaseException {
        return (DataSourceBuilder)this.dataSourceBuilderListener.getInstance(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource tryGetDataSource(String id) throws BaseException {
        ConcurrentHashMap<String, DataSource> concurrentHashMap = this.dataSources;
        synchronized (concurrentHashMap) {
            if (this.dataSources.containsKey(id)) {
                return this.dataSources.get(id);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message updateDataSource(String id, Map<String, String> content) throws BaseException {
        ConcurrentHashMap<String, DataSource> concurrentHashMap = this.dataSources;
        synchronized (concurrentHashMap) {
            if (this.dataSources.containsKey(id)) {
                if (this.threads.containsKey(id)) {
                    this.threads.get(id).interrupt();
                    this.threads.remove(id);
                }
                this.dataSources.put(id, this.connectDataSource(content));
                return new Message("Update successful", String.format("Data source with id %s successful updated.", id), Message.Status.INFO);
            }
        }
        throw new NotFoundException(String.format("Data source with id %s not found.", id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message deleteDataSource(String id) throws BaseException {
        ConcurrentHashMap<String, DataSource> concurrentHashMap = this.dataSources;
        synchronized (concurrentHashMap) {
            if (this.dataSources.containsKey(id)) {
                this.dataSources.remove(id);
                if (this.threads.containsKey(id)) {
                    this.threads.get(id).interrupt();
                    this.threads.remove(id);
                }
                return new Message("Delete successful", String.format("Data source with id %s successful deleted.", id), Message.Status.INFO);
            }
        }
        throw new NotFoundException(String.format("Data source with id %s not found.", id));
    }

    public DataSource createDataSource(Map<String, String> content) throws BaseException {
        String typeKey = content.get(Helper.Keys.DataBuilderId);
        String dataSourceId = content.get(Helper.Keys.SourceId);
        if (typeKey == null) {
            throw new MissingArgumentException(String.format("Argument %s is missing.", Helper.Keys.DataBuilderId));
        }
        if (dataSourceId == null) {
            throw new MissingArgumentException(String.format("Argument %s is missing.", Helper.Keys.SourceId));
        }
        if (this.tryGetDataSource(dataSourceId) != null) {
            throw new AlreadyExistsException(String.format("Data source with id %s already exists.", dataSourceId));
        }
        DataSource dataSource = this.connectDataSource(content);
        this.addDataSource(dataSourceId, dataSource);
        return dataSource;
    }

    private DataSource connectDataSource(Map<String, String> content) throws BaseException {
        String typeKey = content.get(Helper.Keys.DataBuilderId);
        String dataSourceId = content.get(Helper.Keys.SourceId);
        if (typeKey == null) {
            throw new MissingArgumentException(String.format("Argument %s is missing.", Helper.Keys.DataBuilderId));
        }
        if (dataSourceId == null) {
            throw new MissingArgumentException(String.format("Argument %s is missing.", Helper.Keys.SourceId));
        }
        DataSourceBuilder connection = (DataSourceBuilder)this.dataSourceBuilderListener.getInstance(typeKey);
        final DataSource source = (DataSource)connection.createInstance(dataSourceId, content);
        source.setState(DataInformation.DataState.CONNECTING);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    source.connect();
                    source.setState(DataInformation.DataState.READY);
                    DataAccess.this.threads.remove(source.getId());
                }
                catch (BaseException e) {
                    e.printStackTrace();
                    DataAccess.this.threads.remove(source.getId());
                    DataAccess.this.dataSources.remove(source.getId());
                }
            }
        };
        this.threads.put(dataSourceId, thread);
        thread.start();
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDataSource(String id, DataSource dataSource) {
        ConcurrentHashMap<String, DataSource> concurrentHashMap = this.dataSources;
        synchronized (concurrentHashMap) {
            this.dataSources.put(id, dataSource);
        }
    }

    public List<DataInformation> getDataInformations() throws BaseException {
        ArrayList<DataInformation> list = new ArrayList<DataInformation>();
        list.addAll(this.dataSources.values());
        list.addAll(this.dataSourceBuilderListener.getAll());
        return list;
    }

    public String getKey() {
        return "data-access";
    }

    public String getDescription() {
        return null;
    }
}

