/*
 * Decompiled with CFR 0.152.
 */
package librec.data;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import librec.data.MatrixEntry;
import librec.data.SparseVector;
import librec.data.VectorEntry;
import librec.util.Stats;

public class SparseMatrix
implements Iterable<MatrixEntry>,
Serializable {
    private static final long serialVersionUID = 8024536511172609539L;
    protected int numRows;
    protected int numColumns;
    protected double[] rowData;
    protected int[] rowPtr;
    protected int[] colInd;
    protected double[] colData;
    protected int[] colPtr;
    protected int[] rowInd;

    public SparseMatrix(int rows, int cols, Table<Integer, Integer, ? extends Number> dataTable, Multimap<Integer, Integer> colMap) {
        this.numRows = rows;
        this.numColumns = cols;
        this.construct(dataTable, colMap);
    }

    public SparseMatrix(int rows, int cols, Table<Integer, Integer, ? extends Number> dataTable) {
        this(rows, cols, dataTable, null);
    }

    private SparseMatrix(int rows, int cols) {
        this.numRows = rows;
        this.numColumns = cols;
    }

    public SparseMatrix(SparseMatrix mat) {
        this.numRows = mat.numRows;
        this.numColumns = mat.numColumns;
        this.copyCRS(mat.rowData, mat.rowPtr, mat.colInd);
        this.copyCCS(mat.colData, mat.colPtr, mat.rowInd);
    }

    private void copyCRS(double[] data, int[] ptr, int[] idx) {
        int i;
        this.rowData = new double[data.length];
        for (i = 0; i < this.rowData.length; ++i) {
            this.rowData[i] = data[i];
        }
        this.rowPtr = new int[ptr.length];
        for (i = 0; i < this.rowPtr.length; ++i) {
            this.rowPtr[i] = ptr[i];
        }
        this.colInd = new int[idx.length];
        for (i = 0; i < this.colInd.length; ++i) {
            this.colInd[i] = idx[i];
        }
    }

    private void copyCCS(double[] data, int[] ptr, int[] idx) {
        int i;
        this.colData = new double[data.length];
        for (i = 0; i < this.colData.length; ++i) {
            this.colData[i] = data[i];
        }
        this.colPtr = new int[ptr.length];
        for (i = 0; i < this.colPtr.length; ++i) {
            this.colPtr[i] = ptr[i];
        }
        this.rowInd = new int[idx.length];
        for (i = 0; i < this.rowInd.length; ++i) {
            this.rowInd[i] = idx[i];
        }
    }

    public SparseMatrix clone() {
        return new SparseMatrix(this);
    }

    public SparseMatrix transpose() {
        SparseMatrix tr = new SparseMatrix(this.numColumns, this.numRows);
        tr.copyCRS(this.rowData, this.rowPtr, this.colInd);
        tr.copyCCS(this.colData, this.colPtr, this.rowInd);
        return tr;
    }

    public int[] getRowPointers() {
        return this.rowPtr;
    }

    public int[] getColumnIndices() {
        return this.colInd;
    }

    public int size() {
        int size = 0;
        for (MatrixEntry me : this) {
            if (me.get() == 0.0) continue;
            ++size;
        }
        return size;
    }

    public Table<Integer, Integer, Double> getDataTable() {
        HashBasedTable res = HashBasedTable.create();
        for (MatrixEntry me : this) {
            if (me.get() == 0.0) continue;
            res.put((Object)me.row(), (Object)me.column(), (Object)me.get());
        }
        return res;
    }

    private void construct(Table<Integer, Integer, ? extends Number> dataTable, Multimap<Integer, Integer> columnStructure) {
        int col;
        Iterator<Object> iterator;
        int i;
        int nnz = dataTable.size();
        this.rowPtr = new int[this.numRows + 1];
        this.colInd = new int[nnz];
        this.rowData = new double[nnz];
        int j = 0;
        for (i = 1; i <= this.numRows; ++i) {
            Set cols = dataTable.row((Object)(i - 1)).keySet();
            this.rowPtr[i] = this.rowPtr[i - 1] + cols.size();
            iterator = cols.iterator();
            while (iterator.hasNext()) {
                col = (Integer)iterator.next();
                this.colInd[j++] = col;
                if (col >= 0 && col < this.numColumns) continue;
                throw new IllegalArgumentException("colInd[" + j + "]=" + col + ", which is not a valid column index");
            }
            Arrays.sort(this.colInd, this.rowPtr[i - 1], this.rowPtr[i]);
        }
        this.colPtr = new int[this.numColumns + 1];
        this.rowInd = new int[nnz];
        this.colData = new double[nnz];
        j = 0;
        for (i = 1; i <= this.numColumns; ++i) {
            Set rows = columnStructure != null ? columnStructure.get((Object)(i - 1)) : dataTable.column((Object)(i - 1)).keySet();
            this.colPtr[i] = this.colPtr[i - 1] + rows.size();
            iterator = rows.iterator();
            while (iterator.hasNext()) {
                int row = (Integer)iterator.next();
                this.rowInd[j++] = row;
                if (row >= 0 && row < this.numRows) continue;
                throw new IllegalArgumentException("rowInd[" + j + "]=" + row + ", which is not a valid row index");
            }
            Arrays.sort(this.rowInd, this.colPtr[i - 1], this.colPtr[i]);
        }
        for (Table.Cell en : dataTable.cellSet()) {
            int row = (Integer)en.getRowKey();
            col = (Integer)en.getColumnKey();
            double val = ((Number)en.getValue()).doubleValue();
            this.set(row, col, val);
        }
    }

    public int numRows() {
        return this.numRows;
    }

    public int numColumns() {
        return this.numColumns;
    }

    public double[] getData() {
        return this.rowData;
    }

    public void set(int row, int column, double val) {
        int index = this.getCRSIndex(row, column);
        this.rowData[index] = val;
        index = this.getCCSIndex(row, column);
        this.colData[index] = val;
    }

    public void add(int row, int column, double val) {
        int index;
        int n = index = this.getCRSIndex(row, column);
        this.rowData[n] = this.rowData[n] + val;
        int n2 = index = this.getCCSIndex(row, column);
        this.colData[n2] = this.colData[n2] + val;
    }

    public double get(int row, int column) {
        int index = Arrays.binarySearch(this.colInd, this.rowPtr[row], this.rowPtr[row + 1], column);
        if (index >= 0) {
            return this.rowData[index];
        }
        return 0.0;
    }

    public SparseVector row(int row) {
        SparseVector sv = new SparseVector(this.numColumns);
        if (row < this.numRows) {
            for (int j = this.rowPtr[row]; j < this.rowPtr[row + 1]; ++j) {
                int col = this.colInd[j];
                double val = this.get(row, col);
                if (val == 0.0) continue;
                sv.set(col, val);
            }
        }
        return sv;
    }

    public List<Integer> getColumns(int row) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        if (row < this.numRows) {
            for (int j = this.rowPtr[row]; j < this.rowPtr[row + 1]; ++j) {
                int col = this.colInd[j];
                double val = this.get(row, col);
                if (val == 0.0) continue;
                res.add(col);
            }
        }
        return res;
    }

    public LoadingCache<Integer, SparseVector> rowCache(String cacheSpec) {
        LoadingCache cache = CacheBuilder.from((String)cacheSpec).build((CacheLoader)new CacheLoader<Integer, SparseVector>(){

            public SparseVector load(Integer rowId) throws Exception {
                return SparseMatrix.this.row(rowId);
            }
        });
        return cache;
    }

    public LoadingCache<Integer, List<Integer>> rowColumnsCache(String cacheSpec) {
        LoadingCache cache = CacheBuilder.from((String)cacheSpec).build((CacheLoader)new CacheLoader<Integer, List<Integer>>(){

            public List<Integer> load(Integer rowId) throws Exception {
                return SparseMatrix.this.getColumns(rowId);
            }
        });
        return cache;
    }

    public LoadingCache<Integer, SparseVector> columnCache(String cacheSpec) {
        LoadingCache cache = CacheBuilder.from((String)cacheSpec).build((CacheLoader)new CacheLoader<Integer, SparseVector>(){

            public SparseVector load(Integer columnId) throws Exception {
                return SparseMatrix.this.column(columnId);
            }
        });
        return cache;
    }

    public LoadingCache<Integer, List<Integer>> columnRowsCache(String cacheSpec) {
        LoadingCache cache = CacheBuilder.from((String)cacheSpec).build((CacheLoader)new CacheLoader<Integer, List<Integer>>(){

            public List<Integer> load(Integer colId) throws Exception {
                return SparseMatrix.this.getRows(colId);
            }
        });
        return cache;
    }

    public SparseVector row(int row, int except) {
        SparseVector sv = new SparseVector(this.numColumns);
        for (int j = this.rowPtr[row]; j < this.rowPtr[row + 1]; ++j) {
            double val;
            int col = this.colInd[j];
            if (col == except || (val = this.get(row, col)) == 0.0) continue;
            sv.set(col, val);
        }
        return sv;
    }

    public int rowSize(int row) {
        int size = 0;
        for (int j = this.rowPtr[row]; j < this.rowPtr[row + 1]; ++j) {
            int col = this.colInd[j];
            if (this.get(row, col) == 0.0) continue;
            ++size;
        }
        return size;
    }

    public List<Integer> rows() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        block0: for (int row = 0; row < this.numRows; ++row) {
            for (int j = this.rowPtr[row]; j < this.rowPtr[row + 1]; ++j) {
                int col = this.colInd[j];
                if (this.get(row, col) == 0.0) continue;
                list.add(row);
                continue block0;
            }
        }
        return list;
    }

    public SparseVector column(int col) {
        SparseVector sv = new SparseVector(this.numRows);
        if (col < this.numColumns) {
            for (int j = this.colPtr[col]; j < this.colPtr[col + 1]; ++j) {
                int row = this.rowInd[j];
                double val = this.get(row, col);
                if (val == 0.0) continue;
                sv.set(row, val);
            }
        }
        return sv;
    }

    public int columnSize(int col) {
        int size = 0;
        for (int j = this.colPtr[col]; j < this.colPtr[col + 1]; ++j) {
            int row = this.rowInd[j];
            double val = this.get(row, col);
            if (val == 0.0) continue;
            ++size;
        }
        return size;
    }

    public List<Integer> getRows(int col) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        if (col < this.numColumns) {
            for (int j = this.colPtr[col]; j < this.colPtr[col + 1]; ++j) {
                int row = this.rowInd[j];
                double val = this.get(row, col);
                if (val == 0.0) continue;
                res.add(row);
            }
        }
        return res;
    }

    public List<Integer> columns() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        block0: for (int col = 0; col < this.numColumns; ++col) {
            for (int j = this.colPtr[col]; j < this.colPtr[col + 1]; ++j) {
                int row = this.rowInd[j];
                double val = this.get(row, col);
                if (val == 0.0) continue;
                list.add(col);
                continue block0;
            }
        }
        return list;
    }

    public double sum() {
        return Stats.sum(this.rowData);
    }

    public double mean() {
        return this.sum() / (double)this.size();
    }

    public void normalize(double min, double max) {
        assert (max > min);
        for (MatrixEntry me : this) {
            double entry = me.get();
            if (entry == 0.0) continue;
            me.set((entry - min) / (max - min));
        }
    }

    public void normalize(double max) {
        this.normalize(0.0, max);
    }

    public void standardize(boolean isByRow) {
        int iters = isByRow ? this.numRows : this.numColumns;
        for (int iter = 0; iter < iters; ++iter) {
            SparseVector vec;
            SparseVector sparseVector = vec = isByRow ? this.row(iter) : this.column(iter);
            if (vec.getCount() <= 0) continue;
            double[] data = vec.getData();
            double mu = Stats.mean(data);
            double sigma = Stats.sd(data, mu);
            for (VectorEntry ve : vec) {
                int idx = ve.index();
                double val = ve.get();
                double z = (val - mu) / sigma;
                if (isByRow) {
                    this.set(iter, idx, z);
                    continue;
                }
                this.set(idx, iter, z);
            }
        }
    }

    public static void reshape(SparseMatrix mat) {
        double val;
        SparseMatrix res = new SparseMatrix(mat.numRows, mat.numColumns);
        int nnz = mat.size();
        res.rowData = new double[nnz];
        res.colInd = new int[nnz];
        res.rowPtr = new int[mat.numRows + 1];
        int index = 0;
        for (int i = 1; i < mat.rowPtr.length; ++i) {
            for (int j = mat.rowPtr[i - 1]; j < mat.rowPtr[i]; ++j) {
                val = mat.rowData[j];
                int col = mat.colInd[j];
                if (val == 0.0) continue;
                res.rowData[index] = val;
                res.colInd[index] = col;
                ++index;
            }
            res.rowPtr[i] = index;
        }
        res.colData = new double[nnz];
        res.rowInd = new int[nnz];
        res.colPtr = new int[mat.numColumns + 1];
        index = 0;
        for (int j = 1; j < mat.colPtr.length; ++j) {
            for (int i = mat.colPtr[j - 1]; i < mat.colPtr[j]; ++i) {
                val = mat.colData[i];
                int row = mat.rowInd[i];
                if (val == 0.0) continue;
                res.colData[index] = val;
                res.rowInd[index] = row;
                ++index;
            }
            res.colPtr[j] = index;
        }
        mat.rowData = res.rowData;
        mat.colInd = res.colInd;
        mat.rowPtr = res.rowPtr;
        mat.colData = res.colData;
        mat.rowInd = res.rowInd;
        mat.colPtr = res.colPtr;
    }

    public SparseMatrix reshape(int rows, int cols) {
        HashBasedTable data = HashBasedTable.create();
        HashMultimap colMap = HashMultimap.create();
        for (int i = 1; i < this.rowPtr.length; ++i) {
            for (int j = this.rowPtr[i - 1]; j < this.rowPtr[i]; ++j) {
                int row = i - 1;
                int col = this.colInd[j];
                double val = this.rowData[j];
                if (val == 0.0) continue;
                int oldIndex = row * this.numColumns + col;
                int rowIndex = oldIndex / cols;
                int colIndex = oldIndex % cols;
                data.put((Object)rowIndex, (Object)colIndex, (Object)val);
                colMap.put((Object)colIndex, (Object)rowIndex);
            }
        }
        return new SparseMatrix(rows, cols, (Table<Integer, Integer, ? extends Number>)data, (Multimap<Integer, Integer>)colMap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%d\t%d\t%d\n", this.numRows, this.numColumns, this.size()));
        for (MatrixEntry me : this) {
            if (me.get() == 0.0) continue;
            sb.append(String.format("%d\t%d\t%f\n", me.row(), me.column(), me.get()));
        }
        return sb.toString();
    }

    public String matString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Dimension: ").append(this.numRows).append(" x ").append(this.numColumns).append("\n");
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numColumns; ++j) {
                sb.append(this.get(i, j));
                if (j >= this.numColumns - 1) continue;
                sb.append("\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private int getCRSIndex(int row, int col) {
        int i = Arrays.binarySearch(this.colInd, this.rowPtr[row], this.rowPtr[row + 1], col);
        if (i >= 0 && this.colInd[i] == col) {
            return i;
        }
        throw new IndexOutOfBoundsException("Entry (" + (row + 1) + ", " + (col + 1) + ") is not in the matrix structure");
    }

    private int getCCSIndex(int row, int col) {
        int i = Arrays.binarySearch(this.rowInd, this.colPtr[col], this.colPtr[col + 1], row);
        if (i >= 0 && this.rowInd[i] == row) {
            return i;
        }
        throw new IndexOutOfBoundsException("Entry (" + (row + 1) + ", " + (col + 1) + ") is not in the matrix structure");
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new MatrixIterator();
    }

    private class MatrixIterator
    implements Iterator<MatrixEntry> {
        private int row;
        private int cursor;
        private SparseMatrixEntry entry;

        public MatrixIterator() {
            this.entry = new SparseMatrixEntry();
            this.nextNonEmptyRow();
        }

        private void nextNonEmptyRow() {
            while (this.row < SparseMatrix.this.numRows && SparseMatrix.this.rowPtr[this.row] == SparseMatrix.this.rowPtr[this.row + 1]) {
                ++this.row;
            }
            this.cursor = SparseMatrix.this.rowPtr[this.row];
        }

        @Override
        public boolean hasNext() {
            return this.cursor < SparseMatrix.this.rowData.length;
        }

        @Override
        public MatrixEntry next() {
            this.entry.update(this.row, this.cursor);
            if (this.cursor < SparseMatrix.this.rowPtr[this.row + 1] - 1) {
                ++this.cursor;
            } else {
                ++this.row;
                this.nextNonEmptyRow();
            }
            return this.entry;
        }

        @Override
        public void remove() {
            this.entry.set(0.0);
        }
    }

    private class SparseMatrixEntry
    implements MatrixEntry {
        private int row;
        private int cursor;

        private SparseMatrixEntry() {
        }

        public void update(int row, int cursor) {
            this.row = row;
            this.cursor = cursor;
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public int column() {
            return SparseMatrix.this.colInd[this.cursor];
        }

        @Override
        public double get() {
            return SparseMatrix.this.rowData[this.cursor];
        }

        @Override
        public void set(double value) {
            SparseMatrix.this.rowData[this.cursor] = value;
        }
    }
}

