/*
 * Decompiled with CFR 0.152.
 */
package librec.ext;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import librec.data.SparseVector;
import librec.intf.Recommender;
import librec.util.Lists;

@Configuration(key="lambda", type=ConfigurationItem.ConfigurationItemType.Double)
public class Hybrid
extends Recommender {
    Table<Integer, Integer, Double> userItemRanks = HashBasedTable.create();
    public double lambda;
    Map<Integer, Integer> itemDegrees = new HashMap<Integer, Integer>();

    public Hybrid() {
        this.isRankingPred = true;
    }

    @Override
    public void initModel() throws Exception {
        for (int j = 0; j < this.numItems; ++j) {
            this.itemDegrees.put(j, this.trainMatrix.columnSize(j));
        }
    }

    @Override
    public double ranking(int u, int j) {
        if (!this.userItemRanks.containsRow((Object)u)) {
            double sum;
            this.userItemRanks.clear();
            SparseVector uv = this.trainMatrix.row(u);
            List<Integer> items = Lists.toList(uv.getIndex());
            HashMap<Integer, Double> userResources = new HashMap<Integer, Double>();
            for (int v = 0; v < this.numUsers; ++v) {
                SparseVector vv = this.trainMatrix.row(v);
                sum = 0.0;
                int kj = vv.getCount();
                int[] nArray = vv.getIndex();
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int item = nArray[i];
                    if (!items.contains(item)) continue;
                    sum += 1.0 / Math.pow(this.itemDegrees.get(item).intValue(), this.lambda);
                }
                if (kj <= 0) continue;
                userResources.put(v, sum / (double)kj);
            }
            for (int i = 0; i < this.numItems; ++i) {
                if (items.contains(i)) continue;
                SparseVector iv = this.trainMatrix.column(i);
                sum = 0.0;
                for (int user : iv.getIndex()) {
                    sum += userResources.containsKey(user) ? (Double)userResources.get(user) : 0.0;
                }
                double score = sum / Math.pow(this.itemDegrees.get(i).intValue(), 1.0 - this.lambda);
                this.userItemRanks.put((Object)u, (Object)i, (Object)score);
            }
        }
        return this.userItemRanks.contains((Object)u, (Object)j) ? (Double)this.userItemRanks.get((Object)u, (Object)j) : 0.0;
    }
}

