/*
 * Decompiled with CFR 0.152.
 */
package librec.intf;

import com.google.common.collect.Table;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.intf.Recommender;

@Configurations(value={@Configuration(key="burnIn", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double, description="burn-in period", value="30"), @Configuration(key="sampleLag", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Integer, value="10", description="sample lag (if -1 only one sample taken)"), @Configuration(key="numFactors", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Integer, value="10"), @Configuration(key="numIters", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Integer, value="30"), @Configuration(key="lRate", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double, value="0.005"), @Configuration(key="initAlpha", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double, value="0.01"), @Configuration(key="initBeta", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double, value="0.01")})
public class GraphicRecommender
extends Recommender {
    public int numFactors;
    public double initAlpha;
    public double initBeta;
    public int burnIn;
    public int sampleLag;
    public int numIters;
    public static int numIntervals;
    protected Table<Integer, Integer, Integer> z;
    protected DenseMatrix Nik;
    protected DenseMatrix Nki;
    protected DenseMatrix Nuk;
    protected DenseVector Nk;
    protected DenseVector Nu;
    protected DenseVector Ni;
    protected DenseVector alpha;
    protected DenseVector beta;
    protected DenseMatrix PukSum;
    protected DenseMatrix PikSum;
    protected DenseMatrix PkiSum;
    protected DenseMatrix Puk;
    protected DenseMatrix Pki;
    protected DenseMatrix Pik;
    protected int numStats = 0;
    protected double loss;
    protected double lastLoss;

    @Override
    public void buildModel() throws Exception {
        for (int iter = 1; iter <= this.numIters; ++iter) {
            this.eStep();
            this.mStep();
            if (iter <= this.burnIn || iter % this.sampleLag != 0) continue;
            this.readoutParams();
            if (this.isConverged(iter)) break;
        }
        this.estimateParams();
    }

    protected void mStep() {
    }

    protected boolean isConverged(int iter) throws Exception {
        return false;
    }

    protected void estimateParams() {
    }

    protected void eStep() {
    }

    protected void readoutParams() {
    }
}

