/*
 * Decompiled with CFR 0.152.
 */
package librec.intf;

import com.google.common.cache.LoadingCache;
import com.recalot.model.rec.librec.DataDAO;
import java.util.ArrayList;
import java.util.List;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.data.SymmMatrix;
import librec.util.Sims;

public abstract class Recommender {
    public SparseMatrix timeMatrix;
    public String guavaCacheSpec = "maximumSize=200,expireAfterAccess=2m";
    public boolean isRankingPred;
    public int numUsers;
    public int numItems;
    public int numRates;
    protected static List<Double> ratingScale;
    public int numLevels;
    public double maxRate;
    public double minRate;
    public long minTimestamp;
    public long maxTimestamp;
    public double initMean = 0.0;
    public double initStd = 0.1;
    public double smallValue = 0.01;
    protected LoadingCache<Integer, SparseVector> userCache;
    protected LoadingCache<Integer, List<Integer>> userItemsCache;
    protected LoadingCache<Integer, List<Integer>> itemUsersCache;
    protected SparseMatrix trainMatrix;
    protected SymmMatrix corrs;
    public double globalMean;
    protected DataDAO dataDAO;

    public void setDao(DataDAO dataDAO) {
        this.dataDAO = dataDAO;
        try {
            SparseMatrix[] matrixes = dataDAO.readData(new String[0]);
            this.trainMatrix = matrixes[0];
            this.timeMatrix = matrixes[1];
            ratingScale = dataDAO.getRatingScale();
            this.minRate = ratingScale.get(0);
            this.maxRate = ratingScale.get(ratingScale.size() - 1);
            if (this.minRate == this.maxRate) {
                this.minRate = 0.0;
            }
            this.numLevels = ratingScale.size();
            this.numUsers = dataDAO.numUsers();
            this.numItems = dataDAO.numItems();
            this.minTimestamp = dataDAO.getMinTimestamp();
            this.maxTimestamp = dataDAO.getMaxTimestamp();
            this.numRates = this.trainMatrix.size();
            this.globalMean = this.trainMatrix.sum() / (double)this.numRates;
            if (this.isRankingPred) {
                this.corrs = new SymmMatrix(this.numItems);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initModel() throws Exception {
    }

    protected SymmMatrix buildCorrs(boolean isUser, String similarityMeasure, int shrinkage) {
        int count = isUser ? this.numUsers : this.numItems;
        SymmMatrix corrs = new SymmMatrix(count);
        for (int i = 0; i < count; ++i) {
            SparseVector iv;
            SparseVector sparseVector = iv = isUser ? this.trainMatrix.row(i) : this.trainMatrix.column(i);
            if (iv.getCount() == 0) continue;
            for (int j = i + 1; j < count; ++j) {
                SparseVector jv = isUser ? this.trainMatrix.row(j) : this.trainMatrix.column(j);
                double sim = this.correlation(iv, jv, similarityMeasure, shrinkage);
                if (Double.isNaN(sim)) continue;
                corrs.set(i, j, sim);
            }
        }
        return corrs;
    }

    protected double correlation(SparseVector iv, SparseVector jv, String method, int shrinkage) {
        ArrayList<Double> is = new ArrayList<Double>();
        ArrayList<Double> js = new ArrayList<Double>();
        int[] nArray = jv.getIndex();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer idx = nArray[i];
            if (!iv.contains(idx)) continue;
            is.add(iv.get(idx));
            js.add(jv.get(idx));
        }
        double sim = 0.0;
        switch (method.toLowerCase()) {
            case "cos": {
                sim = Sims.cos(is, js);
                break;
            }
            case "cos-binary": {
                sim = iv.inner(jv) / (Math.sqrt(iv.inner(iv)) * Math.sqrt(jv.inner(jv)));
                break;
            }
            case "msd": {
                sim = Sims.msd(is, js);
                break;
            }
            case "cpc": {
                sim = Sims.cpc(is, js, (this.minRate + this.maxRate) / 2.0);
                break;
            }
            case "exjaccard": {
                sim = Sims.exJaccard(is, js);
                break;
            }
            default: {
                sim = Sims.pcc(is, js);
            }
        }
        if (!Double.isNaN(sim)) {
            int n2 = is.size();
            if (shrinkage > 0) {
                sim *= (double)n2 / ((double)(n2 + shrinkage) + 0.0);
            }
        }
        return sim;
    }

    public void buildModel() throws Exception {
    }

    public void postModel() throws Exception {
    }

    public double predict(int u, int j, boolean bound) throws Exception {
        double pred = this.predict(u, j);
        if (bound) {
            if (pred > this.maxRate) {
                pred = this.maxRate;
            }
            if (pred < this.minRate) {
                pred = this.minRate;
            }
        }
        return pred;
    }

    public double predict(int u, int j) throws Exception {
        return this.globalMean;
    }

    protected double perplexity(int u, int j, double r) throws Exception {
        return 0.0;
    }

    public double ranking(int u, int j) throws Exception {
        return this.predict(u, j, false);
    }

    protected double g(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    protected double gd(double x) {
        return this.g(x) * this.g(-x);
    }

    protected double gaussian(double x, double mu, double sigma) {
        return Math.exp(-0.5 * Math.pow(x - mu, 2.0) / (sigma * sigma));
    }

    protected double normalize(double rate) {
        if (this.maxRate - this.minRate == 0.0) {
            return rate;
        }
        return (rate - this.minRate) / (this.maxRate - this.minRate);
    }

    protected void checkBinary() {
    }

    protected double denormalize(double pred) {
        return this.minRate + pred * (this.maxRate - this.minRate);
    }
}

