/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import librec.data.DenseVector;
import librec.data.SparseVector;
import librec.intf.IterativeRecommender;
import librec.util.Lists;
import librec.util.Randoms;
import librec.util.Stats;

@Configuration(key="lamda", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Integer)
public class AoBPR
extends IterativeRecommender {
    private int loopNumber;
    private int lamda;
    private int lamda_Item;
    private double[] var;
    private int[][] factorRanking;
    private double[] RankingPro;

    public AoBPR() {
        this.isRankingPred = true;
        this.initByNorm = false;
    }

    @Override
    public void initModel() throws Exception {
        int i;
        super.initModel();
        this.lamda_Item = this.lamda * this.numItems;
        this.loopNumber = (int)((double)this.numItems * Math.log(this.numItems));
        this.var = new double[this.numFactors];
        this.factorRanking = new int[this.numFactors][this.numItems];
        this.RankingPro = new double[this.numItems];
        double sum = 0.0;
        for (i = 0; i < this.numItems; ++i) {
            this.RankingPro[i] = Math.exp(-(i + 1) / this.lamda_Item);
            sum += this.RankingPro[i];
        }
        i = 0;
        while (i < this.numItems) {
            int n = i++;
            this.RankingPro[n] = this.RankingPro[n] / sum;
        }
    }

    @Override
    public void buildModel() throws Exception {
        int countIter = 0;
        for (int iter = 1; iter <= this.numIters; ++iter) {
            this.loss = 0.0;
            int smax = this.numUsers * 100;
            for (int s = 0; s < smax; ++s) {
                int randomJIndex;
                double[] pfc;
                int f;
                SparseVector pu;
                if (countIter % this.loopNumber == 0) {
                    this.updateRankingInFactor();
                    countIter = 0;
                }
                ++countIter;
                int u = 0;
                int i = 0;
                int j = 0;
                while ((pu = this.trainMatrix.row(u = Randoms.uniform(this.numUsers))).getCount() == 0) {
                }
                int[] is = pu.getIndex();
                i = is[Randoms.uniform(is.length)];
                do {
                    int index;
                    randomJIndex = 0;
                    while ((randomJIndex = Randoms.discrete(this.RankingPro)) > this.numItems) {
                    }
                    pfc = new double[this.numFactors];
                    double sumfc = 0.0;
                    for (index = 0; index < this.numFactors; ++index) {
                        double temp = Math.abs(this.P.get(u, index));
                        sumfc += temp * this.var[index];
                        pfc[index] = temp * this.var[index];
                    }
                    index = 0;
                    while (index < this.numFactors) {
                        int n = index++;
                        pfc[n] = pfc[n] / sumfc;
                    }
                } while (pu.contains(j = this.P.get(u, f = Randoms.discrete(pfc)) > 0.0 ? this.factorRanking[f][randomJIndex] : this.factorRanking[f][this.numItems - randomJIndex - 1]));
                double xui = this.predict(u, i);
                double xuj = this.predict(u, j);
                double xuij = xui - xuj;
                double vals = -Math.log(this.g(xuij));
                this.loss += vals;
                double cmg = this.g(-xuij);
                for (int f2 = 0; f2 < this.numFactors; ++f2) {
                    double puf = this.P.get(u, f2);
                    double qif = this.Q.get(i, f2);
                    double qjf = this.Q.get(j, f2);
                    this.P.add(u, f2, this.lRate * (cmg * (qif - qjf) - this.regU * puf));
                    this.Q.add(i, f2, this.lRate * (cmg * puf - this.regI * qif));
                    this.Q.add(j, f2, this.lRate * (cmg * -puf - this.regI * qjf));
                    this.loss += this.regU * puf * puf + this.regI * qif * qif + this.regI * qjf * qjf;
                }
            }
            if (this.isConverged(iter)) break;
        }
    }

    public void updateRankingInFactor() {
        for (int factorIndex = 0; factorIndex < this.numFactors; ++factorIndex) {
            DenseVector factorVector = this.Q.column(factorIndex).clone();
            List<Map.Entry<Integer, Double>> sort = this.sortByDenseVectorValue(factorVector);
            double[] valueList = new double[this.numItems];
            for (int i = 0; i < this.numItems; ++i) {
                this.factorRanking[factorIndex][i] = sort.get(i).getKey();
                valueList[i] = sort.get(i).getValue();
            }
            this.var[factorIndex] = Stats.var(valueList);
        }
    }

    public List<Map.Entry<Integer, Double>> sortByDenseVectorValue(DenseVector vector) {
        HashMap<Integer, Double> keyValPair = new HashMap<Integer, Double>();
        int length = vector.getData().length;
        for (int i = 0; i < length; ++i) {
            keyValPair.put(i, vector.get(i));
        }
        return Lists.sortMap(keyValPair, true);
    }
}

