/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.MatrixEntry;
import librec.intf.GraphicRecommender;

@Configurations(value={@Configuration(key="K", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Integer), @Configuration(key="L", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Integer), @Configuration(key="initGamma", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double), @Configuration(key="initSigma", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double)})
public class BHfree
extends GraphicRecommender {
    public double initGamma;
    public double initSigma;
    public int K;
    public int L;
    private DenseMatrix Nkl;
    private int[][][] Nklr;
    private int[][][] Nkli;
    private Table<Integer, Integer, Integer> Zk;
    private Table<Integer, Integer, Integer> Zl;
    private DenseMatrix Puk;
    private DenseMatrix Pkl;
    private DenseMatrix PukSum;
    private DenseMatrix PklSum;
    private double[][][] Pklr;
    private double[][][] Pkli;
    private double[][][] PklrSum;
    private double[][][] PkliSum;

    @Override
    public void initModel() throws Exception {
        this.Nuk = new DenseMatrix(this.numUsers, this.K);
        this.Nu = new DenseVector(this.numUsers);
        this.Nkl = new DenseMatrix(this.K, this.L);
        this.Nk = new DenseVector(this.K);
        this.Nklr = new int[this.K][this.L][this.numLevels];
        this.Nkli = new int[this.K][this.L][this.numItems];
        this.Zk = HashBasedTable.create();
        this.Zl = HashBasedTable.create();
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            int i = me.column();
            double rate = me.get();
            int r = ratingScale.indexOf(rate);
            int k = (int)((double)this.K * Math.random());
            int l = (int)((double)this.L * Math.random());
            this.Nuk.add(u, k, 1.0);
            this.Nu.add(u, 1.0);
            this.Nkl.add(k, l, 1.0);
            this.Nk.add(k, 1.0);
            int[] nArray = this.Nklr[k][l];
            int n = r;
            nArray[n] = nArray[n] + 1;
            int[] nArray2 = this.Nkli[k][l];
            int n2 = i;
            nArray2[n2] = nArray2[n2] + 1;
            this.Zk.put((Object)u, (Object)i, (Object)k);
            this.Zl.put((Object)u, (Object)i, (Object)l);
        }
        this.PukSum = new DenseMatrix(this.numUsers, this.K);
        this.PklSum = new DenseMatrix(this.K, this.L);
        this.PklrSum = new double[this.K][this.L][this.numLevels];
        this.Pklr = new double[this.K][this.L][this.numLevels];
        this.PkliSum = new double[this.K][this.L][this.numItems];
        this.Pkli = new double[this.K][this.L][this.numItems];
    }

    @Override
    protected void eStep() {
        for (MatrixEntry me : this.trainMatrix) {
            int w;
            int z;
            int u = me.row();
            int i = me.column();
            double rate = me.get();
            int r = ratingScale.indexOf(rate);
            int k = (Integer)this.Zk.get((Object)u, (Object)i);
            int l = (Integer)this.Zl.get((Object)u, (Object)i);
            this.Nuk.add(u, k, -1.0);
            this.Nu.add(u, -1.0);
            this.Nkl.add(k, l, -1.0);
            this.Nk.add(k, -1.0);
            int[] nArray = this.Nklr[k][l];
            int n = r;
            nArray[n] = nArray[n] - 1;
            int[] nArray2 = this.Nkli[k][l];
            int n2 = i;
            nArray2[n2] = nArray2[n2] - 1;
            DenseMatrix Pzw = new DenseMatrix(this.K, this.L);
            double sum = 0.0;
            for (int z2 = 0; z2 < this.K; ++z2) {
                for (int w2 = 0; w2 < this.L; ++w2) {
                    double v1 = (this.Nuk.get(u, k) + this.initAlpha) / (this.Nu.get(u) + (double)this.K * this.initAlpha);
                    double v2 = (this.Nkl.get(k, l) + this.initBeta) / (this.Nk.get(k) + (double)this.L * this.initBeta);
                    double v3 = ((double)this.Nklr[k][l][r] + this.initGamma) / (this.Nkl.get(k, l) + (double)this.numLevels * this.initGamma);
                    double v4 = ((double)this.Nkli[k][l][i] + this.initSigma) / (this.Nkl.get(k, l) + (double)this.numItems * this.initSigma);
                    double val = v1 * v2 * v3 * v4;
                    Pzw.set(z2, w2, val);
                    sum += val;
                }
            }
            Pzw = Pzw.scale(1.0 / sum);
            double[] Pz = new double[this.K];
            for (z = 0; z < this.K; ++z) {
                Pz[z] = Pzw.sumOfRow(z);
            }
            for (z = 1; z < this.K; ++z) {
                int n3 = z;
                Pz[n3] = Pz[n3] + Pz[z - 1];
            }
            double rand = Math.random();
            for (k = 0; k < this.K && !(rand < Pz[k]); ++k) {
            }
            double[] Pw = new double[this.L];
            for (w = 0; w < this.L; ++w) {
                Pw[w] = Pzw.sumOfColumn(w);
            }
            for (w = 1; w < this.L; ++w) {
                int n4 = w;
                Pw[n4] = Pw[n4] + Pw[w - 1];
            }
            rand = Math.random();
            for (l = 0; l < this.L && !(rand < Pw[l]); ++l) {
            }
            this.Nuk.add(u, k, 1.0);
            this.Nu.add(u, 1.0);
            this.Nkl.add(k, l, 1.0);
            this.Nk.add(k, 1.0);
            int[] nArray3 = this.Nklr[k][l];
            int n5 = r;
            nArray3[n5] = nArray3[n5] + 1;
            int[] nArray4 = this.Nkli[k][l];
            int n6 = i;
            nArray4[n6] = nArray4[n6] + 1;
            this.Zk.put((Object)u, (Object)i, (Object)k);
            this.Zl.put((Object)u, (Object)i, (Object)l);
        }
    }

    @Override
    protected void readoutParams() {
        int l;
        int k;
        for (int u = 0; u < this.numUsers; ++u) {
            for (int k2 = 0; k2 < this.K; ++k2) {
                this.PukSum.add(u, k2, (this.Nuk.get(u, k2) + this.initAlpha) / (this.Nu.get(u) + (double)this.K * this.initAlpha));
            }
        }
        for (k = 0; k < this.K; ++k) {
            for (l = 0; l < this.L; ++l) {
                this.PklSum.add(k, l, (this.Nkl.get(k, l) + this.initBeta) / (this.Nk.get(k) + (double)this.L * this.initBeta));
            }
        }
        for (k = 0; k < this.K; ++k) {
            for (l = 0; l < this.L; ++l) {
                for (int r = 0; r < this.numLevels; ++r) {
                    double[] dArray = this.PklrSum[k][l];
                    int n = r;
                    dArray[n] = dArray[n] + ((double)this.Nklr[k][l][r] + this.initGamma) / (this.Nkl.get(k, l) + (double)this.numLevels * this.initGamma);
                }
            }
        }
        for (k = 0; k < this.K; ++k) {
            for (l = 0; l < this.L; ++l) {
                for (int i = 0; i < this.numItems; ++i) {
                    double[] dArray = this.PkliSum[k][l];
                    int n = i;
                    dArray[n] = dArray[n] + ((double)this.Nkli[k][l][i] + this.initSigma) / (this.Nkl.get(k, l) + (double)this.numItems * this.initSigma);
                }
            }
        }
        ++this.numStats;
    }

    @Override
    protected void estimateParams() {
        int l;
        int k;
        double scale = 1.0 / (double)this.numStats;
        this.Puk = this.PukSum.scale(scale);
        this.Pkl = this.PklSum.scale(scale);
        for (k = 0; k < this.K; ++k) {
            for (l = 0; l < this.L; ++l) {
                for (int r = 0; r < this.numLevels; ++r) {
                    this.Pklr[k][l][r] = this.PklrSum[k][l][r] * scale;
                }
            }
        }
        for (k = 0; k < this.K; ++k) {
            for (l = 0; l < this.L; ++l) {
                for (int i = 0; i < this.numItems; ++i) {
                    this.Pkli[k][l][i] = this.PkliSum[k][l][i] * scale;
                }
            }
        }
    }

    @Override
    public double predict(int u, int j) throws Exception {
        double sum = 0.0;
        double probs = 0.0;
        for (int r = 0; r < this.numLevels; ++r) {
            double rate = (Double)ratingScale.get(r);
            double prob = 0.0;
            for (int k = 0; k < this.K; ++k) {
                for (int l = 0; l < this.L; ++l) {
                    prob += this.Puk.get(u, k) * this.Pkl.get(k, l) * this.Pklr[k][l][r];
                }
            }
            sum += rate * prob;
            probs += prob;
        }
        return sum / probs;
    }

    @Override
    public double ranking(int u, int j) throws Exception {
        double rank = 0.0;
        for (int r = 0; r < this.numLevels; ++r) {
            double rate = (Double)ratingScale.get(r);
            double prob = 0.0;
            for (int k = 0; k < this.K; ++k) {
                for (int l = 0; l < this.L; ++l) {
                    prob += this.Puk.get(u, k) * this.Pkl.get(k, l) * this.Pkli[k][l][j] * this.Pklr[k][l][r];
                }
            }
            rank += rate * prob;
        }
        return rank;
    }
}

