/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import librec.data.SparseVector;
import librec.intf.IterativeRecommender;

public class CLiMF
extends IterativeRecommender {
    @Override
    public void buildModel() throws Exception {
        for (int iter = 1; iter <= this.numIters; ++iter) {
            this.loss = 0.0;
            for (int u = 0; u < this.numUsers; ++u) {
                int j;
                SparseVector uv = this.trainMatrix.row(u);
                double[] sgds = new double[this.numFactors];
                for (int f = 0; f < this.numFactors; ++f) {
                    double sgd = -this.regU * this.P.get(u, f);
                    for (int j2 : uv.getIndex()) {
                        double fuj = this.predict(u, j2);
                        double qjf = this.Q.get(j2, f);
                        sgd += this.g(-fuj) * qjf;
                        for (int k : uv.getIndex()) {
                            if (k == j2) continue;
                            double fuk = this.predict(u, k);
                            double qkf = this.Q.get(k, f);
                            double x = fuk - fuj;
                            sgd += this.gd(x) / (1.0 - this.g(x)) * (qjf - qkf);
                        }
                    }
                    sgds[f] = sgd;
                }
                HashMap itemSgds = new HashMap();
                for (int j3 : uv.getIndex()) {
                    double fuj = this.predict(u, j3);
                    ArrayList<Double> jSgds = new ArrayList<Double>();
                    for (int f = 0; f < this.numFactors; ++f) {
                        double puf = this.P.get(u, f);
                        double qjf = this.Q.get(j3, f);
                        double yuj = uv.contains(j3) ? 1.0 : 0.0;
                        double sgd = yuj * this.g(-fuj) * puf - this.regI * qjf;
                        for (int k : uv.getIndex()) {
                            if (k == j3) continue;
                            double fuk = this.predict(u, k);
                            double x = fuk - fuj;
                            sgd += this.gd(-x) * (1.0 / (1.0 - this.g(x)) - 1.0 / (1.0 - this.g(-x))) * puf;
                        }
                        jSgds.add(sgd);
                    }
                    itemSgds.put(j3, jSgds);
                }
                for (int f = 0; f < this.numFactors; ++f) {
                    this.P.add(u, f, this.lRate * sgds[f]);
                }
                for (j = 0; j < this.numItems; ++j) {
                    List jSgds = (List)itemSgds.get(j);
                    for (int f = 0; f < this.numFactors; ++f) {
                        this.Q.add(j, f, this.lRate * (Double)jSgds.get(f));
                    }
                }
                for (j = 0; j < this.numItems; ++j) {
                    if (uv.contains(j)) {
                        double fuj = this.predict(u, j);
                        this.loss += Math.log(this.g(fuj));
                        for (int k : uv.getIndex()) {
                            double fuk = this.predict(u, k);
                            this.loss += Math.log(1.0 - this.g(fuk - fuj));
                        }
                    }
                    for (int f = 0; f < this.numFactors; ++f) {
                        double puf = this.P.get(u, f);
                        double qjf = this.Q.get(j, f);
                        this.loss += -0.5 * (this.regU * puf * puf + this.regI * qjf * qjf);
                    }
                }
            }
            if (this.isConverged(iter)) break;
        }
    }
}

