/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.SparseVector;
import librec.data.VectorEntry;
import librec.intf.IterativeRecommender;
import librec.util.Randoms;

@Configurations(value={@Configuration(key="rho", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Integer), @Configuration(key="alpha", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double)})
public class FISMauc
extends IterativeRecommender {
    public int rho;
    public double alpha;

    public FISMauc() {
        this.isRankingPred = true;
    }

    @Override
    public void initModel() throws Exception {
        this.P = new DenseMatrix(this.numItems, this.numFactors);
        this.Q = new DenseMatrix(this.numItems, this.numFactors);
        this.P.init(this.smallValue);
        this.Q.init(this.smallValue);
        this.itemBias = new DenseVector(this.numItems);
        this.itemBias.init(this.smallValue);
        this.userItemsCache = this.trainMatrix.rowColumnsCache(this.guavaCacheSpec);
    }

    @Override
    public void buildModel() throws Exception {
        for (int iter = 1; iter <= this.numIters; ++iter) {
            this.loss = 0.0;
            for (int u : this.trainMatrix.rows()) {
                SparseVector Ru = this.trainMatrix.row(u);
                int[] ratedItems = Ru.getIndex();
                for (VectorEntry ve : Ru) {
                    int i = ve.index();
                    double rui = ve.get();
                    ArrayList<Integer> js = new ArrayList<Integer>();
                    int len = 0;
                    while (len < this.rho) {
                        int j = Randoms.uniform(this.numItems);
                        if (Ru.contains(j) || js.contains(j)) continue;
                        js.add(j);
                        ++len;
                    }
                    double wu = Ru.getCount() - 1 > 0 ? Math.pow(Ru.getCount() - 1, -this.alpha) : 0.0;
                    double[] x = new double[this.numFactors];
                    Iterator iterator = js.iterator();
                    while (iterator.hasNext()) {
                        int j = (Integer)iterator.next();
                        double sum_i = 0.0;
                        double sum_j = 0.0;
                        for (int k : ratedItems) {
                            if (i != k) {
                                sum_i += DenseMatrix.rowMult(this.P, k, this.Q, i);
                            }
                            sum_j += DenseMatrix.rowMult(this.P, k, this.Q, j);
                        }
                        double bi = this.itemBias.get(i);
                        double bj = this.itemBias.get(j);
                        double pui = bi + wu * sum_i;
                        double puj = bj + Math.pow(Ru.getCount(), -this.alpha) * sum_j;
                        double ruj = 0.0;
                        double eij = rui - ruj - (pui - puj);
                        this.loss += eij * eij;
                        this.itemBias.add(i, this.lRate * (eij - this.regB * bi));
                        this.itemBias.add(j, -this.lRate * (eij - this.regB * bj));
                        this.loss += this.regB * bi * bi - this.regB * bj * bj;
                        int f = 0;
                        while (f < this.numFactors) {
                            double qif = this.Q.get(i, f);
                            double qjf = this.Q.get(j, f);
                            double sum_k = 0.0;
                            for (int k : ratedItems) {
                                if (k == i) continue;
                                sum_k += this.P.get(k, f);
                            }
                            double delta_i = eij * wu * sum_k - this.regI * qif;
                            this.Q.add(i, f, this.lRate * delta_i);
                            double delta_j = eij * wu * sum_k - this.regI * qjf;
                            this.Q.add(j, f, -this.lRate * delta_j);
                            int n = f++;
                            x[n] = x[n] + eij * (qif - qjf);
                            this.loss += this.regI * qif * qif - this.regI * qjf * qjf;
                        }
                    }
                    for (Object j : (Iterator)ratedItems) {
                        if (j == i) continue;
                        for (int f = 0; f < this.numFactors; ++f) {
                            double pjf = this.P.get((int)j, f);
                            double delta = wu * x[f] / (double)this.rho - this.regI * pjf;
                            this.P.add((int)j, f, this.lRate * delta);
                            this.loss += this.regI * pjf * pjf;
                        }
                    }
                }
            }
            this.loss *= 0.5;
            if (this.isConverged(iter)) break;
        }
    }

    @Override
    public double predict(int u, int i) throws Exception {
        double sum = 0.0;
        int count = 0;
        List items = (List)this.userItemsCache.get((Object)u);
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            int j = (Integer)iterator.next();
            if (i == j) continue;
            sum += DenseMatrix.rowMult(this.P, j, this.Q, i);
            ++count;
        }
        double wu = count > 0 ? Math.pow(count, -this.alpha) : 0.0;
        return this.itemBias.get(i) + wu * sum;
    }
}

