/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import java.util.List;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.MatrixEntry;
import librec.intf.IterativeRecommender;

public class LRMF
extends IterativeRecommender {
    public DenseVector userExp;

    public LRMF() {
        this.isRankingPred = true;
        this.initByNorm = false;
    }

    @Override
    public void initModel() throws Exception {
        super.initModel();
        this.userExp = new DenseVector(this.numUsers);
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            double ruj = me.get();
            this.userExp.add(u, Math.exp(ruj));
        }
    }

    @Override
    public void buildModel() throws Exception {
        for (int iter = 1; iter <= this.numIters; ++iter) {
            this.loss = 0.0;
            for (MatrixEntry me : this.trainMatrix) {
                int u = me.row();
                int j = me.column();
                double ruj = me.get();
                double pred = DenseMatrix.rowMult(this.P, u, this.Q, j);
                double uexp = 0.0;
                List<Integer> items = this.trainMatrix.getColumns(u);
                for (int i : items) {
                    uexp += Math.exp(DenseMatrix.rowMult(this.P, u, this.Q, i));
                }
                this.loss -= Math.exp(ruj) / this.userExp.get(u) * Math.log(Math.exp(pred) / uexp);
                for (int f = 0; f < this.numFactors; ++f) {
                    double puf = this.P.get(u, f);
                    double qjf = this.Q.get(j, f);
                    double delta_u = (Math.exp(ruj) / this.userExp.get(u) - Math.exp(pred) / uexp) * this.gd(pred) * qjf - this.regU * puf;
                    double delta_j = (Math.exp(ruj) / this.userExp.get(u) - Math.exp(pred) / uexp) * this.gd(pred) * puf - this.regI * qjf;
                    this.P.add(u, f, this.lRate * delta_u);
                    this.Q.add(j, f, this.lRate * delta_j);
                    this.loss += 0.5 * this.regU * puf * puf + 0.5 * this.regI * qjf * qjf;
                }
            }
            if (this.isConverged(iter)) break;
        }
    }
}

