/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.controller.experiments;

import com.recalot.common.GenericServiceListener;
import com.recalot.common.Helper;
import com.recalot.common.builder.DataSplitterBuilder;
import com.recalot.common.builder.MetricBuilder;
import com.recalot.common.builder.RecommenderBuilder;
import com.recalot.common.communication.TemplateResult;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.controller.ExperimentsController;
import com.recalot.common.interfaces.controller.RequestAction;
import com.recalot.common.interfaces.model.data.DataAccess;
import com.recalot.common.interfaces.model.data.DataSource;
import com.recalot.common.interfaces.model.experiment.DataSplitter;
import com.recalot.common.interfaces.model.experiment.Experiment;
import com.recalot.common.interfaces.model.experiment.ExperimentAccess;
import com.recalot.common.interfaces.model.experiment.Metric;
import com.recalot.common.interfaces.model.rec.Recommender;
import com.recalot.common.interfaces.template.ExperimentTemplate;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;

public class ExperimentsController
implements com.recalot.common.interfaces.controller.ExperimentsController,
Closeable {
    private final BundleContext context;
    private final GenericServiceListener<RecommenderBuilder> recommenderAccess;
    private final GenericServiceListener<ExperimentTemplate> templates;
    private final GenericServiceListener<DataAccess> dataAccess;
    private final GenericServiceListener<ExperimentAccess> experimentsAccess;
    private final GenericServiceListener<DataSplitterBuilder> dataSplitterAccess;
    private final GenericServiceListener<MetricBuilder> metricsListener;
    private final ContextProvider contextProvider;

    public ExperimentsController(BundleContext context) {
        this.context = context;
        this.recommenderAccess = new GenericServiceListener(context, RecommenderBuilder.class.getName());
        this.dataAccess = new GenericServiceListener(context, DataAccess.class.getName());
        this.experimentsAccess = new GenericServiceListener(context, ExperimentAccess.class.getName());
        this.dataSplitterAccess = new GenericServiceListener(context, DataSplitterBuilder.class.getName());
        this.templates = new GenericServiceListener(context, ExperimentTemplate.class.getName());
        this.metricsListener = new GenericServiceListener(context, MetricBuilder.class.getName());
        this.contextProvider = new ContextProvider(context);
        this.context.addServiceListener(this.recommenderAccess);
        this.context.addServiceListener(this.dataAccess);
        this.context.addServiceListener(this.experimentsAccess);
        this.context.addServiceListener(this.dataSplitterAccess);
        this.context.addServiceListener(this.templates);
        this.context.addServiceListener(this.metricsListener);
        this.context.addServiceListener((ServiceListener)this.contextProvider);
    }

    public TemplateResult process(RequestAction action, String templateKey, Map<String, String> param) throws BaseException {
        ExperimentTemplate template = (ExperimentTemplate)this.templates.getInstance(templateKey);
        TemplateResult result = null;
        try {
            switch ((ExperimentsController.ExperimentsRequestAction)action) {
                case GetExperiments: {
                    result = this.getExperiments(template, param);
                    break;
                }
                case CreateExperiment: {
                    result = this.createExperiment(template, param);
                    break;
                }
                case DeleteExperiment: {
                    result = this.deleteExperiment(template, param);
                    break;
                }
                case GetExperiment: {
                    result = this.getExperiment(template, param);
                    break;
                }
                case GetExperimentConfiguration: {
                    result = this.getExperiment(template, param);
                    break;
                }
                case GetMetrics: {
                    result = this.getMetrics(template, param);
                    break;
                }
                case GetMetric: {
                    result = this.getMetric(template, param);
                    break;
                }
                case GetSplitters: {
                    result = this.getSplitters(template, param);
                    break;
                }
                case GetSplitter: {
                    result = this.getSplitter(template, param);
                }
            }
        }
        catch (BaseException ex) {
            result = template.transform(ex);
        }
        return result;
    }

    private TemplateResult getExperiments(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        ExperimentAccess access = (ExperimentAccess)this.experimentsAccess.getFirstInstance();
        List experiments = access.getExperiments();
        if (param.containsKey(Helper.Keys.State)) {
            Experiment.ExperimentState state = Experiment.ExperimentState.valueOf((String)param.get(Helper.Keys.State));
            ArrayList<Experiment> temp = new ArrayList<Experiment>();
            for (Experiment info : experiments) {
                if (info.getState() != state) continue;
                temp.add(info);
            }
            return template.transform(temp);
        }
        return template.transform(experiments);
    }

    private TemplateResult createExperiment(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        ExperimentAccess access = (ExperimentAccess)this.experimentsAccess.getFirstInstance();
        DataAccess dAccess = (DataAccess)this.dataAccess.getFirstInstance();
        ArrayList<Recommender> recommender = new ArrayList<Recommender>();
        String recommenderId = param.get(Helper.Keys.RecommenderId);
        if (recommenderId != null) {
            if (recommenderId.contains(",")) {
                String[] split;
                for (String s : split = recommenderId.split(",")) {
                    if (s == null || s.isEmpty()) continue;
                    Recommender rec = null;
                    if (s.contains("@")) {
                        String[] idSplit = s.split("@");
                        if (idSplit.length > 1) {
                            param.put(idSplit[1] + "." + Helper.Keys.ID, idSplit[1]);
                            param.put(idSplit[1] + "." + Helper.Keys.SourceId, param.get(Helper.Keys.SourceId));
                            rec = (Recommender)((RecommenderBuilder)this.recommenderAccess.getInstance(idSplit[0])).createInstance(idSplit[1], idSplit[1], param);
                        }
                    } else {
                        param.put((String)s + "." + Helper.Keys.ID, s);
                        param.put((String)s + "." + Helper.Keys.SourceId, param.get(Helper.Keys.SourceId));
                        rec = (Recommender)((RecommenderBuilder)this.recommenderAccess.getInstance(s)).createInstance(s, s, param);
                    }
                    recommender.add(rec);
                }
            } else {
                Recommender rec = null;
                if (recommenderId.contains("@")) {
                    String[] idSplit = recommenderId.split("@");
                    if (idSplit.length > 1) {
                        param.put(idSplit[1] + "." + Helper.Keys.ID, idSplit[1]);
                        param.put(idSplit[1] + "." + Helper.Keys.SourceId, param.get(Helper.Keys.SourceId));
                        rec = (Recommender)((RecommenderBuilder)this.recommenderAccess.getInstance(idSplit[0])).createInstance(idSplit[1], idSplit[1], param);
                    }
                } else {
                    param.put(recommenderId + "." + Helper.Keys.ID, recommenderId);
                    param.put(recommenderId + "." + Helper.Keys.SourceId, param.get(Helper.Keys.SourceId));
                    rec = (Recommender)((RecommenderBuilder)this.recommenderAccess.getInstance(recommenderId)).createInstance(recommenderId, recommenderId, param);
                }
                recommender.add(rec);
            }
        }
        DataSource dataSource = dAccess.getDataSource(param.get(Helper.Keys.SourceId));
        String metricIds = param.get(Helper.Keys.MetricIDs);
        HashMap<String, Metric[]> metrics = new HashMap<String, Metric[]>();
        if (metricIds != null) {
            String[] split = metricIds.split(",");
            for (Recommender r : recommender) {
                ArrayList<Metric> m = new ArrayList<Metric>();
                for (String s : split) {
                    if (s != null && !s.isEmpty()) {
                        Metric metric = null;
                        if (s.contains("@")) {
                            String[] idSplit = s.split("@");
                            if (idSplit.length > 1) {
                                metric = (Metric)((MetricBuilder)this.metricsListener.getInstance(idSplit[0])).createInstance(idSplit[1], idSplit[1], param);
                            }
                        } else {
                            metric = (Metric)((MetricBuilder)this.metricsListener.getInstance(s)).createInstance(s, s, param);
                        }
                        m.add(metric);
                    }
                    metrics.put(r.getId(), m.toArray(new Metric[m.size()]));
                }
            }
        }
        DataSplitterBuilder splitterBuilder = (DataSplitterBuilder)this.dataSplitterAccess.getInstance(param.get(Helper.Keys.DataSplitterId));
        DataSplitter splitter = (DataSplitter)splitterBuilder.createInstance(param.get(Helper.Keys.DataSplitterId), param.get(Helper.Keys.DataSplitterId), param);
        return template.transform(access.createExperiment(recommender.toArray(new Recommender[recommender.size()]), dataSource, splitter, metrics, this.contextProvider, param));
    }

    private TemplateResult deleteExperiment(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        ExperimentAccess access = (ExperimentAccess)this.experimentsAccess.getFirstInstance();
        return template.transform(access.deleteExperiment(param.get(Helper.Keys.ExperimentId)));
    }

    private TemplateResult getExperiment(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        ExperimentAccess access = (ExperimentAccess)this.experimentsAccess.getFirstInstance();
        return template.transform(access.getExperiment(param.get(Helper.Keys.ExperimentId)));
    }

    private TemplateResult getSplitter(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        return template.transform((DataSplitterBuilder)this.dataSplitterAccess.getInstance(param.get(Helper.Keys.DataSplitterId)));
    }

    private TemplateResult getSplitters(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        return template.transformSplitters((List)this.dataSplitterAccess.getAll());
    }

    private TemplateResult getMetrics(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        return template.transformMetrics((List)this.metricsListener.getAll());
    }

    private TemplateResult getMetric(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        return template.transform((MetricBuilder)this.metricsListener.getInstance(param.get(Helper.Keys.MetricIDs)));
    }

    @Override
    public void close() throws IOException {
        if (this.recommenderAccess != null) {
            this.context.removeServiceListener(this.recommenderAccess);
        }
        if (this.dataAccess != null) {
            this.context.removeServiceListener(this.dataAccess);
        }
        if (this.templates != null) {
            this.context.removeServiceListener(this.templates);
        }
        if (this.experimentsAccess != null) {
            this.context.removeServiceListener(this.experimentsAccess);
        }
        if (this.dataSplitterAccess != null) {
            this.context.removeServiceListener(this.dataSplitterAccess);
        }
        if (this.metricsListener != null) {
            this.context.removeServiceListener(this.metricsListener);
        }
    }
}

